/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD radar

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#ifndef __HUDRADAR_H__
#define __HUDRADAR_H__

//-----------------------------------------------------------------------------------------------------

#include "HUDObject.h"
#include <deque>

//-----------------------------------------------------------------------------------------------------

class CHUDRadar : public CHUDObject
{

	struct RadarEntity
	{
		EntityId	m_id;
		RadarEntity(EntityId id)
		{ m_id = id; }
		RadarEntity()
		{}

		bool operator<(RadarEntity ent)
		{
			if(ent.m_id > m_id)
				return true;
			return false;
		}
	};

public:

	void AddTagBullet(EntityId iEntityId);

						CHUDRadar(CHUDDraw *pHUDDraw);
	virtual	~	CHUDRadar();

	EntityId m_aiEntitiesId[3];

	float		 m_radarDotSizes[4];

	std::deque<RadarEntity>		m_entitiesOnRadar;

private:

	// CHUDObject
	virtual void	OnUpdate(float fDeltaTime,float fFadeValue);
	// ~CHUDObject

	float m_fTime;

	float					GetRadarSize(IEntity* entity, class CActor* actor);

	bool					IsOnRadar(EntityId id, int first, int last);

	void					AddToRadar(EntityId id);

	int m_iTextureIDEnemy;
	int m_iTextureIDFov;
	int m_iTextureIDPlayer;
	int m_iTextureIDWaypoint;
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------