#include "StdAfx.h"
#include "HUDObject.h"
#include "HUDScore.h"
#include "IGameFramework.h"

CHUDScore::CHUDScore(CHUDDraw *pDraw) : CHUDObject(pDraw)
{
	m_bShow = true;
}

void CHUDScore::OnUpdate(float fDeltaTime,float fFadeValue)
{
	if(m_bShow && GetISystem()->GetIGame()->GetIGameFramework()->IsMultiplayer())
		Render();
}

void CHUDScore::AddEntry(const char* name, int kills, int deaths)
{
	float now = GetISystem()->GetITimer()->GetFrameStartTime().GetMilliSeconds();
	if(now != m_lastUpdate)
	{
		m_lastUpdate = now;
		m_scoreBoard.clear();
	}
	m_scoreBoard.push_back(ScoreEntry(name, kills, deaths));
}

void CHUDScore::Render()
{
	std::vector<ScoreEntry>::iterator it;
	int posX = 50;
	int posY = 200;
	int nr = 1;
	char buffer[10];
	for(it = m_scoreBoard.begin(); it != m_scoreBoard.end(); it++)
	{
		posX = 235;
		ScoreEntry player = *it;
		itoa(nr, buffer, 10);
		string number(buffer);
		number.append(".");
		m_pHUDDraw->DrawText(posX, posY, number.c_str(), 0.8f, 0.1f, 0.5f, 1.0f, HUDDRAWHORIZONTAL_RIGHT);
		m_pHUDDraw->DrawText(posX+23, posY, player.m_name.c_str(), 0.8f, 0.1f, 0.5f, 1.0f, HUDDRAWHORIZONTAL_LEFT);
		m_pHUDDraw->DrawText(posX+285, posY, player.m_deaths.c_str(), 0.8f, 0.1f, 0.5f, 1.0f, HUDDRAWHORIZONTAL_RIGHT);
		m_pHUDDraw->DrawText(posX+345, posY, player.m_kills.c_str(), 0.8f, 0.1f, 0.5f, 1.0f, HUDDRAWHORIZONTAL_RIGHT);
		nr++;
		posY += 15;
	}
}