/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD score board for multiplayer

-------------------------------------------------------------------------
History:
- 27:03:2006: Created by Jan Mller

*************************************************************************/
#ifndef __HUDSCORE_H__
#define __HUDSCORE_H__

class CHUDObject;

class CHUDScore : public CHUDObject
{
	struct ScoreEntry
	{
		string	m_name;
		string	m_kills;
		string	m_deaths;
		string  m_ping;

		ScoreEntry(const char* name, int kills, int deaths) : m_name(name)
		{
			char buffer[128];
			itoa(kills, buffer, 10);
			m_kills = string(buffer);
			itoa(deaths, buffer, 10);
			m_deaths = string(buffer);
		}

		bool operator<(ScoreEntry& entry)
		{
			if(entry.m_kills > m_kills)
				return false;
			else if(m_kills > entry.m_kills)
				return true;
			else
			{
				if(m_deaths < entry.m_deaths)
					return true;
				else
					return false;
			}
			return true;
		}
	};

private:

	float			m_lastUpdate;
	bool			m_bShow;

	void Render();

public:

	CHUDScore(CHUDDraw *pDraw);

	~CHUDScore()
	{
	}

	virtual void OnUpdate(float fDeltaTime,float fFadeValue);

	virtual bool OnInputEvent(const SInputEvent &event )
	{
		return false;
	}

	std::vector<ScoreEntry> m_scoreBoard;

	void AddEntry(const char* name, int kills, int deaths);

	ILINE void SetVisible(bool visible)
	{
		m_bShow = visible;
	}

};

#endif