#include "StdAfx.h"
#include "HUDTextChat.h"
#include "IGameRulesSystem.h"
#include "IActorSystem.h"
#include "HUD.h"

CHUDTextChat::CHUDTextChat(CHUDDraw *pHUDDraw) : CHUDObject(pHUDDraw), m_bIsListening(false), m_fLastInputTime(0),
m_iChatHead(0), m_iCursor(0), m_bAnyCurrentText(false), m_bBlockInput(false)
{
	g_pHUDDraw = pHUDDraw;
	assert(GetISystem()->GetIInput());
	GetISystem()->GetIInput()->AddEventListener(this);
}

CHUDTextChat::~CHUDTextChat()
{
	GetISystem()->GetIInput()->RemoveEventListener(this);
	if(m_bIsListening)
		GetISystem()->GetIInput()->SetExclusiveListener(NULL);
}

void CHUDTextChat::OnUpdate(float fDeltaTime, float fFadeValue)
{

	float now = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();

	//insert some fancy text-box
	

	//render current chat messages over it
	if(m_bAnyCurrentText)
	{
		bool current = false;
		int msgNr = m_iChatHead;
		for(int i = 0; i < CHAT_LENGTH; i++)
		{
			float age = now - m_fChatSpawnTime[msgNr];
			if(age < 5000.0f)
			{
				g_pHUDDraw->DrawText(30, 350+i*20, m_sChatStrings[msgNr].c_str(), 1.0f - (age * 0.0002f), 0.1f, 1.0f, 0.3f, HUDDRAWHORIZONTAL_LEFT);
				current = true;
			}
			msgNr++;
			if(msgNr > CHAT_LENGTH-1)
				msgNr = 0;
		}

		if(!current)
			m_bAnyCurrentText = false;
	}

	//render input text and cursor
	if(m_bIsListening)
	{
		if(m_sInputText.size() > 0)
			g_pHUDDraw->DrawText(30, 450, m_sInputText.c_str(), 1.0f, 0.1f, 1.0f, 0.3f, HUDDRAWHORIZONTAL_LEFT);

		//render cursor
		if(int(now) % 200 < 100)
		{
			string subString = m_sInputText.substr(0, m_iCursor);
			subString.append("_");

			g_pHUDDraw->DrawText(30 , 450, subString.c_str(), 1.0f, 0.1f, 1.0f, 0.3f, HUDDRAWHORIZONTAL_LEFT);
		}
	}

}

bool CHUDTextChat::OnInputEvent(const SInputEvent &event )
{
	if (!GetISystem()->GetIGame()->GetIGameFramework()->IsMultiplayer())
		return false;

	if(!m_bIsListening)
	{
		if(event.keyName == "enter" || event.keyName == "np_enter")	//start text chat
		{
			if(!(!strcmp(m_sLastKey.c_str(), event.keyName.c_str()) &&
				(GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds() - m_fLastInputTime < 150)))
			{
				if(GetISystem()->GetIConsole()->IsOpened())
					return false;
				GetISystem()->GetIInput()->SetExclusiveListener(this);
				m_bIsListening = true;
				m_sLastKey = string(event.keyName.c_str());
				m_fLastInputTime = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
				m_bShiftPressed = false;
				((CHUD*)m_parent)->ShowTextField(true);
			}
		}
		return true;
	}
	else if(event.keyName == "enter" || event.keyName == "np_enter")		//end text chat
	{
		float now = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		if(!(!strcmp(m_sLastKey.c_str(), event.keyName.c_str()) && (now - m_fLastInputTime < 150)))
		{
			m_sLastKey = string(event.keyName.c_str());
			m_fLastInputTime = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
			Flush();
			return true;
		}
	}

	if(event.keyName == "commit")
		return false;
	else if(event.keyName == "rshift" || event.keyName == "lshift")
	{
		if(event.state == eIS_Pressed)
			m_bShiftPressed = true;
		else if(event.state == eIS_Released)
			m_bShiftPressed = false;
		return false;
	}

	const char* kName = 0;
	if(event.keyName.length() > 1)
		kName = event.keyName.c_str();
	else
		kName = GetISystem()->GetIInput()->GetKeyName(event, 1);

	float currentTime = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
	string tempLast(m_sLastKey);

	if ((m_bBlockInput || !strcmp(kName, (tempLast.MakeLower()).c_str()) ||
		(!strcmp(kName, (tempLast.MakeUpper()).c_str()))) && currentTime-m_fLastInputTime < 135)
		return true;

	tempLast = m_sBeforeLastKey;

	if ((m_bBlockInput || !strcmp(kName, (tempLast.MakeLower()).c_str()) ||
		(!strcmp(kName, (tempLast.MakeUpper()).c_str()))) && currentTime-m_fLastInputTime < 150)
		return true;

	if (event.keyName == "backspace" && m_iCursor > 0)
	{
		m_sInputText.erase(m_iCursor-1, 1);
		m_iCursor--;
		m_sBeforeLastKey = m_sLastKey;
		m_sLastKey = string(kName);
		m_fLastInputTime = currentTime;	//increase repeat speed for backspace
	}
	else if (event.keyName == "left")
	{
		if(m_iCursor > 0)
			m_iCursor--;
		m_sBeforeLastKey = m_sLastKey;
		m_sLastKey = string(kName);
		m_fLastInputTime = currentTime;
	}
	else if (event.keyName == "right")
	{
		if(m_iCursor < m_sInputText.size())
			m_iCursor++;
		m_sBeforeLastKey = m_sLastKey;
		m_sLastKey = string(kName);
		m_fLastInputTime = currentTime;
	}
	else if (event.keyName == "space")
	{
		m_sInputText.insert(m_iCursor, 1, ' ');
		SaveKey(kName, currentTime);
	}
	else if (event.keyName == "comma")
	{
		m_sInputText.insert(m_iCursor, 1, ',');
		SaveKey(kName, currentTime);
	}
	else if (event.keyName == "period")
	{
		m_sInputText.insert(m_iCursor, 1, '.');
		SaveKey(kName, currentTime);
	}
	else if (event.keyName == "np_add")
	{
		m_sInputText.insert(m_iCursor, 1, '+');
		SaveKey(kName, currentTime);
	}
	else if (event.keyName == "np_subtract")
	{
		m_sInputText.insert(m_iCursor, 1, '-');
		SaveKey(kName, currentTime);
	}
	else if (event.keyName == "minus" && m_bShiftPressed)	//hack?!
	{
		m_sInputText.insert(m_iCursor, 1, '?');
		SaveKey(kName, currentTime);
	}
	else	//text input
	{
		if(m_sInputText.size()>95)	//emergency flush ...
		{
			GetISystem()->GetIGame()->GetIGameFramework()->GetIGameRulesSystem()->GetCurrentGameRules()->SendChatMessage(
				eChatToAll, GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor()->GetEntityId(), 0, m_sInputText.c_str());

			m_sInputText.clear();
			m_iCursor = 0;
		}

		m_bBlockInput = false;

		//ignore non char-events - can still loose some special signs
		if(event.keyName.length()!=1)
			return false;

		m_fLastInputTime = currentTime;
		m_sBeforeLastKey = m_sLastKey;
		m_sLastKey = string(kName);
		m_sInputText.insert(m_iCursor, 1, *m_sLastKey.c_str());

		if(m_bShiftPressed)
			m_bBlockInput = true;

		m_iCursor++;
	}

	return true;
}

void CHUDTextChat::Flush()
{

	if(m_sInputText.size() > 0)
	{
	//broadcast text / send to receivers ...
		GetISystem()->GetIGame()->GetIGameFramework()->GetIGameRulesSystem()->GetCurrentGameRules()->SendChatMessage(
			eChatToAll, GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor()->GetEntityId(), 0, m_sInputText.c_str());

		m_sInputText.clear();
		m_iCursor = 0;
	}

	m_bIsListening = false;
	GetISystem()->GetIInput()->SetExclusiveListener(NULL);
	((CHUD*)m_parent)->ShowTextField(false);
}

void CHUDTextChat::AddChatMessage(const char* msg)
{
	m_sChatStrings[m_iChatHead] = string(msg);
	m_fChatSpawnTime[m_iChatHead] = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
	m_iChatHead++;
	if(m_iChatHead > CHAT_LENGTH-1)
		m_iChatHead = 0;
	m_bAnyCurrentText = true;
}

void CHUDTextChat::SaveKey(const char* kName, const float& current)
{
	m_iCursor++;
	m_sBeforeLastKey = m_sLastKey;
	m_sLastKey = string(kName);
	m_fLastInputTime = current;
}