/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD text chat - receives text input and broadcasts it to other players

-------------------------------------------------------------------------
History:
- 07:03:2006: Created by Jan Mller

*************************************************************************/
#ifndef __HUDTEXTCHAT_H__
#define __HUDTEXTCHAT_H__

//-----------------------------------------------------------------------------------------------------

#include "HUDObject.h"
#include <IInput.h>

static const int CHAT_LENGTH = 5;

class CHUDTextChat : public CHUDObject,public IInputEventListener
{

public:
	CHUDTextChat(CHUDDraw *pHUDDraw);

	~CHUDTextChat();

	virtual void OnUpdate(float fDeltaTime,float fFadeValue);

	virtual bool OnInputEvent(const SInputEvent &event );

	//add arriving multiplayer chat messages here
	virtual void AddChatMessage(const char* msg);

private:
	virtual void Flush();

	virtual void SaveKey(const char* kName, const float& current);

	string		m_sInputText;
	int				m_iCursor;
	bool			m_bIsListening;
	CHUDDraw *g_pHUDDraw;

	bool			m_bBlockInput;
	bool			m_bShiftPressed;

	string		m_sChatStrings[CHAT_LENGTH];
	float			m_fChatSpawnTime[CHAT_LENGTH];
	int				m_iChatHead;

	float			m_fLastInputTime;
	string		m_sLastKey;
	string		m_sBeforeLastKey;
	bool			m_bAnyCurrentText;
};

#endif