/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2006.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 14:02:2006   11:29 : Created by AlexL

*************************************************************************/
#include "StdAfx.h"
#include "ScriptBind_HUD.h"
#include "HUD.h"
#include "IGameObject.h"

//------------------------------------------------------------------------
CScriptBind_HUD::CScriptBind_HUD(ISystem *pSystem, IGameFramework *pGameFramework)
: m_pSystem(pSystem),
	m_pSS(pSystem->GetIScriptSystem()),
	m_pGameFW(pGameFramework)
{
	Init(m_pSS, m_pSystem, 1);

	RegisterMethods();
	RegisterGlobals();
}

//------------------------------------------------------------------------
CScriptBind_HUD::~CScriptBind_HUD()
{
}

//------------------------------------------------------------------------
void CScriptBind_HUD::AttachTo(CHUD *pHUD)
{
	IScriptTable *pScriptTable = pHUD->GetEntity()->GetScriptTable();

	if (pScriptTable)
	{
		SmartScriptTable thisTable(m_pSS);

		thisTable->SetValue("__this", ScriptHandle(pHUD));
		thisTable->Delegate(GetMethodsTable());

		pScriptTable->SetValue("flashhud", thisTable);
	}
}


//------------------------------------------------------------------------
void CScriptBind_HUD::RegisterGlobals()
{
	m_pSS->SetGlobalValue("MO_DEACTIVATED", CHUDMissionObjective::DEACTIVATED);
	m_pSS->SetGlobalValue("MO_COMPLETED", CHUDMissionObjective::COMPLETED);
	m_pSS->SetGlobalValue("MO_FAILED", CHUDMissionObjective::FAILED);
	m_pSS->SetGlobalValue("MO_ACTIVATED", CHUDMissionObjective::ACTIVATED);
}

//------------------------------------------------------------------------
void CScriptBind_HUD::RegisterMethods()
{
#undef SCRIPT_REG_CLASSNAME
#define SCRIPT_REG_CLASSNAME &CScriptBind_HUD::

	SCRIPT_REG_TEMPLFUNC(SetObjectiveStatus,"objective,status");
	SCRIPT_REG_TEMPLFUNC(SetObjectiveEntity,"objective,entity");
#undef SCRIPT_REG_CLASSNAME
}

//------------------------------------------------------------------------
CHUD* CScriptBind_HUD::GetHUD(IFunctionHandler *pH)
{
	return static_cast<CHUD*> (pH->GetThis());
}

//------------------------------------------------------------------------
/* v)rtual */ int CScriptBind_HUD::SetObjectiveStatus(IFunctionHandler *pH,const char* pObjectiveID, int status)
{
	CHUD *pHUD = GetHUD(pH);
	if (!pHUD)
		return pH->EndFunction();
	CHUDMissionObjective* pObj = pHUD->GetMissionObjectiveSystem().GetMissionObjective(pObjectiveID);
	assert (pObj != 0);
	pObj->SetStatus((CHUDMissionObjective::HUDMissionStatus)status);
	return pH->EndFunction();  
}

//------------------------------------------------------------------------
/* virtual */ int CScriptBind_HUD::SetObjectiveEntity(IFunctionHandler *pH,const char* pObjectiveID, ScriptHandle entityID)
{
	CHUD *pHUD = GetHUD(pH);
	if (!pHUD)
		return pH->EndFunction();
	CHUDMissionObjective* pObj = pHUD->GetMissionObjectiveSystem().GetMissionObjective(pObjectiveID);
	assert (pObj != 0);
	pObj->SetTrackedEntity((EntityId)entityID.n);
	return pH->EndFunction();  
}