/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2006.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Script Binding for HUD
  
 -------------------------------------------------------------------------
  History:
  - 14:02:2005   11:30 : Created by AlexL

*************************************************************************/
#ifndef __SCRIPTBIND_HUD_H__
#define __SCRIPTBIND_HUD_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include <IScriptSystem.h>
#include <ScriptHelpers.h>

struct IItemSystem;
struct IGameFramework;
class CHUD;

class CScriptBind_HUD :
	public CScriptableBase
{
public:
	CScriptBind_HUD(ISystem *pSystem, IGameFramework *pGameFramework);
	virtual ~CScriptBind_HUD();

	void AttachTo(CHUD *pWeapon);

protected:
	virtual int SetObjectiveStatus(IFunctionHandler *pH,const char* pObjectiveID, int status);
	virtual int SetObjectiveEntity(IFunctionHandler *pH,const char* pObjectiveID, ScriptHandle entityID);

private:
	void RegisterGlobals();
	void RegisterMethods();
	CHUD* GetHUD(IFunctionHandler *pH);

	ISystem						*m_pSystem;
	IScriptSystem			*m_pSS;
	IGameFramework		*m_pGameFW;
};

#endif //__SCRIPTBIND_HUD_H__