/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 08:12:2005   14:14 : Created by MichaelR (port from Marcios HomingMissile.lua)

*************************************************************************/
#include "StdAfx.h"
#include "HomingMissile.h"
#include "Actor.h"
#include "Game.h"

//------------------------------------------------------------------------
CHomingMissile::CHomingMissile()
{
  m_isCruising = false;
  m_isDescending = false;
  m_playerView = false;
  m_targetPos.zero();
  m_targetId = 0;
}

//------------------------------------------------------------------------
CHomingMissile::~CHomingMissile()
{

}

//------------------------------------------------------------------------
void CHomingMissile::Launch(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity)
{
  CRocket::Launch(pos, dir, velocity);

  m_dir = dir;

  m_cruiseAltitude = GetParam("cruise_altitude", m_cruiseAltitude);
  m_cruiseAltitude += pos.z;

  m_accel = GetParam("accel", m_accel);
  m_turnSpeed = GetParam("turn_speed", m_turnSpeed);
  m_maxSpeed = GetParam("max_speed", m_maxSpeed);
  m_alignAltitude = GetParam("align_altitude", m_alignAltitude);
  m_descendDistance = GetParam("descend_distance", m_descendDistance);

  // if no targetId/pos set, launch dumb  
  /*if (m_targetPos.IsZero())
  {
    IActor* pActor = GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor();
    if (pActor && pActor->IsPlayer()) 
    {
      m_playerView = true;
      CryLog("HomingMissile tracking players view");
    }
    else
      CryLog("HomingMissile: no player!");
    
  }
  else
    CryLog("HomingMissile got dest %.1f %.1f %.1f", m_targetPos.x, m_targetPos.y, m_targetPos.z);
    */
}

//------------------------------------------------------------------------
void CHomingMissile::Update(SEntityUpdateContext &ctx, int updateSlot)
{
  CRocket::Update(ctx, updateSlot);


  IRenderer* pRenderer = GetISystem()->GetIRenderer();
  float color[4] = {1,1,1,1};
  const static float step = 15.f;  
  float y = 20.f;    
  
  // update destination if required
  if (m_playerView)
  { 
    CCamera& cam = GetISystem()->GetViewCamera();

    static const unsigned int objTypes = ent_all;    
    static const int flags = rwi_stop_at_pierceable|rwi_colltype_any|rwi_any_hit;                      
    static const float maxDist = 500.f;
    
    IPhysicalWorld* pWorld = GetISystem()->GetIPhysicalWorld();
    IPhysicalEntity *pSkip = GetEntity()->GetPhysics();
    ray_hit hit;
    int hits = 0;

    if (hits = pWorld->RayWorldIntersection(cam.GetPosition() + 1.5f*cam.GetViewdir(), cam.GetViewdir()*maxDist, objTypes, flags, &hit, 1, &pSkip, 1))
    {
      SetDestination(hit.pt);
      //pRenderer->Draw2dLabel(5.0f,  y+=25.f,   1.5f, color, false, "Locked!");
    }
    //pRenderer->Draw2dLabel(5.0f, y+=step, 1.5f, color, false, "Target: %.0f %.0f %.0f", hit.pt.x, hit.pt.y, hit.pt.z);
  }
  else if (m_targetId > 0)
  {
    IEntity* pTarget = GetISystem()->GetIEntitySystem()->GetEntity(m_targetId);
    if (pTarget)
    {
      AABB box;
      pTarget->GetWorldBounds(box);
      SetDestination( box.GetCenter() );
    }
  }
  else 
  {
    // update destination pos from weapon
    static IItemSystem* pItemSystem = g_pGame->GetIGameFramework()->GetIItemSystem();
    IItem* pItem = pItemSystem->GetItem(m_weaponId);
    if (pItem && pItem->GetIWeapon())
    {
      SetDestination( pItem->GetIWeapon()->GetDestination() );
    }
  }
  
  pe_status_dynamics status;
  if (!m_pEntity->GetPhysics()->GetStatus(&status))
    return;

  float currentSpeed = status.v.len();
  Vec3 currentPos = m_pEntity->GetWorldPos();
  Vec3 goalDir(ZERO);

  if (!m_targetPos.IsZero())
  {
    float heightDiff = (m_cruiseAltitude-m_alignAltitude) - currentPos.z;

    if (!m_isCruising && heightDiff * sgn(status.v.z) > 0.f)
    {
      // if heading towards align altitude (but not yet reached) accelerate to max speed    
      //pRenderer->Draw2dLabel(5.0f,  y+=step,   1.5f, color, false, "accelerating (%.1f / %.1f)", currentSpeed, m_maxSpeed);    
    }
    else if (!m_isCruising && heightDiff * sgnnz(status.v.z) < 0.f && (status.v.z<0 || status.v.z>0.25f))
    {
      // align to cruise
      if (currentSpeed != 0)
      {
        goalDir = status.v;
        goalDir.z = 0;
        goalDir.normalize();
      }    
      //pRenderer->Draw2dLabel(5.0f,  y+=step, 1.5f, color, false, "aligning"); 
    }
    else
    {
      //pRenderer->Draw2dLabel(5.0f,  y+=step, 1.5f, color, false, "cruising..."); 

      // cruise
      m_isCruising = true;

      if (!m_targetPos.IsZero())
      {
        float groundDistSq = m_targetPos.GetSquaredDistance2D(currentPos);
        float distSq = m_targetPos.GetSquaredDistance(currentPos);
        float descendDistSq = sqr(m_descendDistance);

        if (m_isDescending || groundDistSq <= descendDistSq)
        {
          //pRenderer->Draw2dLabel(5.0f,  y+=step, 1.5f, color, false, "descending!"); 

          if (distSq != 0)
            goalDir = (m_targetPos - currentPos).normalized();
          else 
            goalDir.zero();

          m_isDescending = true;
        }              
        else
        {
          Vec3 airPos = m_targetPos;
          airPos.z = currentPos.z;          
          goalDir = airPos - currentPos;
          if (goalDir.len2() != 0)
            goalDir.Normalize();
        }    
      }
    }
  }  

  if (!goalDir.IsZero() && status.v.len2() > 0.01f)
  {
    Vec3 currentDir = status.v.normalized();    
    float cosine = max(min(currentDir.Dot(goalDir), 0.999f), -0.999f);
    float goalAngle = RAD2DEG(acos_tpl(cosine));
    float maxAngle = m_turnSpeed * ctx.fFrameTime;

    //pRenderer->Draw2dLabel(5.0f,  y+=step, 1.5f, color, false, "goalDir.z: %.3f", goalDir.z); 
    //pRenderer->Draw2dLabel(5.0f,  y+=step, 1.5f, color, false, "goalAngle: %.2f", goalAngle); 
    
    Vec3 dir(ZERO);

    if (goalAngle > maxAngle+0.05f)    
      dir = (Vec3::CreateLerp(currentDir, goalDir, maxAngle/goalAngle)).normalize();
    else //if (goalAngle < 0.005f)
      dir = goalDir;
    
    if (!dir.IsZero())
    {
      pe_action_set_velocity action;
      action.v = dir * currentSpeed;
      m_pEntity->GetPhysics()->Action(&action);
      m_dir = dir;
    }
  }
  
  if (currentSpeed < m_maxSpeed-0.1f)
  {
    pe_action_impulse action;
    action.impulse = m_dir * (m_accel * status.mass * ctx.fFrameTime);
    m_pEntity->GetPhysics()->Action(&action);    
  }

}

