/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HomingMissile

-------------------------------------------------------------------------
History:
- 12:10:2005   11:15 : Created by Mrcio Martins

*************************************************************************/
#ifndef __HomingMissile_H__
#define __HomingMissile_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "Rocket.h"


class CHomingMissile : public CRocket
{
public:
	CHomingMissile();
	virtual ~CHomingMissile();
  
	// CRocket	
  virtual void Update(SEntityUpdateContext &ctx, int updateSlot);
  virtual void Launch(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity);
  virtual void SetDestination(const Vec3& pos){ m_targetPos = pos; }
  virtual void SetDestination(EntityId targetId){ m_targetId = targetId; }
	// ~CRocket

private:  
  Vec3 m_targetPos;
  EntityId m_targetId;
  bool m_playerView;

  // params
  float m_accel;
  float m_turnSpeed;
  float m_maxSpeed;
  float m_cruiseAltitude;
  float m_alignAltitude;
  float m_descendDistance;

  // status
  bool m_isCruising;
  bool m_isDescending;
  Vec3 m_dir;

 
};


#endif // __HomingMissile_H__