/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 27:4:2004: Created by Filippo De Luca

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "Hunter.h"
#include "GameUtils.h"

#include <IViewSystem.h>
#include <IItemSystem.h>
#include <IPhysics.h>
#include <ICryAnimation.h>
#include <ISerialize.h>
#include <IRenderAuxGeom.h>

void CHunter::PostPhysicalize()
{
	CAlien::PostPhysicalize();

	ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
	IPhysicalEntity *pPhysEnt = pCharacter?pCharacter->GetCharacterPhysics(-1):NULL;

	if (pPhysEnt)
	{
		pe_params_pos pp;
		pp.iSimClass = 2;
		pPhysEnt->SetParams(&pp);

		pe_simulation_params ps;
		ps.mass = 0;
		pPhysEnt->SetParams(&ps);
	}
}

void CHunter::CreateCodeEvent(SmartScriptTable &rTable)
{
	const char *event = NULL;
	rTable->GetValue("event",event);

	if (event && !strcmp(event,"IKLook"))
	{
		bool lastIKLook(m_IKLook);
		rTable->GetValue("activate",m_IKLook);
		/*if (m_IKLook &&m_IKLook != lastIKLook)
		{
			for (int i=0;i<4;++i)
			{
				if (m_IKLimbIndex[i]>-1)
				{
					SIKLimb *pLimb = &m_IKLimbs[m_IKLimbIndex[i]];
					Vec3 lPos(pLimb->lAnimPos.x,pLimb->lAnimPos.y,m_footLimit[i][0]);
					m_footGroundPos[i] = GetEntity()->GetSlotWorldTM(pLimb->characterSlot)*lPos;
				}
			}
		}*/
	}
	else
		CActor::CreateCodeEvent(rTable);
}
void CHunter::Revive(bool fromInit)
{
	CAlien::Revive(fromInit);

	memset(m_footGroundPos,0,sizeof(m_footGroundPos));
	memset(m_IKLimbIndex,-1,sizeof(m_IKLimbIndex));
	memset(m_footSoundTime,0,sizeof(m_footSoundTime));

	/*for (int i=0;i<4;++i)
	{
		m_footLimit[i][0] = 100;
		m_footLimit[i][1] = 0;
	}*/

	//FIXME:
	m_footLimit[0][0] = -0.04f;
	m_footLimit[0][1] = 1.79f;

	m_footLimit[1][0] = -0.015f;
	m_footLimit[1][1] = 1.81f;

	m_footLimit[2][0] = 0.46f;
	m_footLimit[2][1] = 2.68f;

	m_footLimit[3][0] = 0.28f;
	m_footLimit[3][1] = 2.59f;
	
	m_IKLook = false;

	m_smoothMovementVec.Set(0,0,0);
	m_balancePoint = GetEntity()->GetWorldPos();

	m_nextStopCheck = 0.0f;

	m_zDelta = 0.0f;

	//FIXME:
	if (m_pAnimatedCharacter)
	{
		SAnimatedCharacterParams params = m_pAnimatedCharacter->GetParams();
		params.flags &= ~eACF_NoTransRot2k;
		params.flags |= eACF_ImmediateStance | eACF_ConstrainDesiredSpeedToXY | eACF_ZCoordinateFromPhysics;
		m_pAnimatedCharacter->SetParams(params);
	}
}

void CHunter::UpdateFiringDir(float frameTime)
{
	m_stats.fireDir = m_viewMtx.GetColumn(1);//Vec3::CreateSlerp(m_stats.fireDir,m_viewMtx.GetColumn(1),1.9f*frameTime);
}

void CHunter::ProcessRotation(float frameTime)
{
	IPhysicalEntity *pPhysEnt = GetEntity()->GetPhysics();

	if (!pPhysEnt)
		return; 

	if (frameTime > 0.1f)
			frameTime = 0.1f;

	float rotSpeed(0.3f);

	if (m_input.viewVector.len2()>0.0f)
	{
		m_eyeMtx.SetRotationVDir(m_input.viewVector.GetNormalizedSafe());
	}

	if (m_input.viewVector.len2()>0.0f)
	{
		m_viewMtx.SetRotationVDir(m_input.viewVector.GetNormalizedSafe());
	}
	else
	{
		Ang3 desiredAngVel(m_input.deltaRotation.x * rotSpeed,0,m_input.deltaRotation.z * rotSpeed);
				
		//rollage
		if (m_input.actions & ACTION_LEANLEFT)
			desiredAngVel.y -= 10.0f * rotSpeed;
		if (m_input.actions & ACTION_LEANRIGHT)
			desiredAngVel.y += 10.0f * rotSpeed;

		Interpolate(m_angularVel,desiredAngVel,3.5f,frameTime);

		Matrix33 yawMtx;
		Matrix33 pitchMtx;
		Matrix33 rollMtx;

		//yaw
		yawMtx.SetRotationZ(m_angularVel.z * gf_PI/180.0f);
		//pitch
		pitchMtx.SetRotationX(m_angularVel.x * gf_PI/180.0f);
		//roll
		if (fabs(m_angularVel.y) > 0.001f)
			rollMtx.SetRotationY(m_angularVel.y * gf_PI/180.0f);
		else
			rollMtx.SetIdentity();
		//
		
		m_viewMtx = m_viewMtx * yawMtx * pitchMtx * rollMtx;
		m_viewMtx.NoScale();
	}

	//now build the base matrix
	Vec3 forward(m_viewMtx.GetColumn(1));
	
	if (Vec3(forward.x,forward.y,0).len2()>0.001f)
	{
		//force the up vector to be 0,0,1 for now
		Vec3 up(0,0,1);
		Vec3 right = (up % forward).GetNormalized();

		Quat goalQuat(Matrix33::CreateFromVectors(right % up,right,up)*Matrix33::CreateRotationZ(gf_PI*-0.5f));
		Quat currQuat(m_baseMtx);

		float rotSpeed = m_params.rotSpeed_min + (1.0f - (max(GetStanceInfo( m_stance )->maxSpeed - max(m_stats.speedModule - m_params.speed_min,0.0f),0.0f) / GetStanceInfo( m_stance )->maxSpeed)) * (m_params.rotSpeed_max - m_params.rotSpeed_min);
		Interpolate(m_turnSpeed,rotSpeed,3.0f,frameTime);

		m_baseMtx = Matrix33(Quat::CreateSlerp( currQuat.GetNormalized(), goalQuat, frameTime * m_turnSpeed ));
		m_baseMtx.NoScale();
	}

}

void CHunter::ProcessMovement(float frameTime)
{
	IPhysicalEntity *pPhysEnt = GetEntity()->GetPhysics();

	if (!pPhysEnt)
		return;

	if (frameTime > 0.1f)
			frameTime = 0.1f;

	//movement
	Interpolate(m_smoothMovementVec,m_input.movementVector,1.0f,frameTime);
	Vec3 move(m_smoothMovementVec);//usually 0, except AIs
	move -= move * (m_baseMtx * Matrix33::CreateScale(Vec3(0,0,1)));//make it flat


//	if (m_input.actions & ACTION_JUMP)
//		m_input.deltaMovement.z += 1.0f; 
//	if (m_input.actions & ACTION_CROUCH)
//		m_input.deltaMovement.z -= 1.0f;

	move += m_baseMtx.GetColumn(0) * m_input.deltaMovement.x;
	move += m_baseMtx.GetColumn(1) * m_input.deltaMovement.y;
	move += m_baseMtx.GetColumn(2) * m_input.deltaMovement.z;

	//cap the movement vector to max 1
	float moveModule(move.len());

	if (moveModule > 1.0f)
	{
		move /= moveModule;
	}

	move *= GetStanceInfo( m_stance )->maxSpeed;

	if (m_stats.sprintLeft)
		move *= m_params.sprintMultiplier;

	SCharacterMoveRequest moveRequest;
	moveRequest.movement = move;
	moveRequest.type = eCMT_Normal;

	ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
	if (true && pCharacter)
	{
		m_stats.desiredSpeed = moveRequest.movement.len();
		//actionMove.dir = m_viewMtx.GetColumn(1) * -2.5f;

		Matrix33 modelMtx(GetEntity()->GetRotation());

		Vec3 up = modelMtx.GetColumn(2);
		Vec3 forward = modelMtx * pCharacter->GetISkeleton()->GetCurrentBodyDirection() * 1.0f;
				
		modelMtx.SetFromVectors(forward % up,forward,up);
		
		//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(GetEntity()->GetWorldPos() + Vec3(0,0,5), ColorB(255,0,0,255), GetEntity()->GetWorldPos() + Vec3(0,0,5) + actionMove.dir * 20.0f, ColorB(255,0,0,255));
	
		Vec3 refDir(m_viewMtx.GetColumn(1) + moveRequest.movement * 10);
		refDir.NormalizeSafe(ZERO);

		float dotY(0.0f);//refDir * m_viewMtx.GetColumn(1));
		float dotX(0.0f);//refDir * m_viewMtx.GetColumn(0));

		//char dirStr[32];
		Vec3 vecDir;
		
		if (dotY<-0.3f)
		{
			m_stats.movementDir = 1;
			vecDir = -modelMtx.GetColumn(1);
			//strcpy(dirStr,"back");
		}
		else if (dotX>0.6f)
		{
			m_stats.movementDir = 2;
			vecDir = modelMtx.GetColumn(0);
			//strcpy(dirStr,"right");
		}
		else if (dotX<-0.6f)
		{
			m_stats.movementDir = 3;
			vecDir = -modelMtx.GetColumn(0);
			//strcpy(dirStr,"left");
		}
		else
		{
			m_stats.movementDir = 0;
			vecDir = modelMtx.GetColumn(1);
			//strcpy(dirStr,"front");
		}

		//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(GetEntity()->GetWorldPos(), ColorB(0,255,255,255), GetEntity()->GetWorldPos() + vecDir * 20.0f, ColorB(0,255,255,255));		
		float color[4] = {1,1,1,1};
		//GetISystem()->GetIRenderer()->Draw2dLabel(300,300, 1.5f, color, false,"dotY:%.1f, dotX:%.1f (%s)", dotY, dotX, dirStr);

		forward = vecDir;
		modelMtx.SetFromVectors(forward % up,forward,up);
		modelMtx.Invert();

		//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(GetEntity()->GetWorldPos(), ColorB(255,0,255,255), GetEntity()->GetWorldPos() + refDir * 20.0f, ColorB(255,255,255,255));

		Vec3 localDir(modelMtx * -refDir);

		float goalZ = -cry_atan2f(-localDir.x,-localDir.y);

		Interpolate(m_zDelta,goalZ,3.0f,frameTime,0.5f);

		float dot(modelMtx.GetInverted().GetColumn(1) * refDir);

		if (dot<0.0f)
		{
			m_stats.desiredSpeed = 0.0f;
			m_nextStopCheck = 1.0f;
		}

		//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(GetEntity()->GetWorldPos(), ColorB(255,0,0,255), GetEntity()->GetWorldPos() + modelMtx.GetInverted().GetColumn(1) * 20.0f, ColorB(255,0,0,255));
		//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(GetEntity()->GetWorldPos(), ColorB(0,0,255,255), GetEntity()->GetWorldPos() + refDir * 20.0f, ColorB(0,0,255,255));
		
		if (m_nextStopCheck>0.001f)
		{
			m_stats.desiredSpeed = 0.0f;
			m_nextStopCheck -= frameTime;
		}

		//GetISystem()->GetIRenderer()->Draw2dLabel(300,320, 1.5f, color, false,"%.1f",m_nextStopCheck);
	}
	else
	{
		m_stats.desiredSpeed = m_stats.speedModule;
		m_zDelta = 0.0f;

		//CryLogAlways("ground %.1f, inair %.1f",m_stats.onGround,m_stats.inAir);
	}

	if (m_pAnimatedCharacter)
		m_pAnimatedCharacter->AddMovement( moveRequest );
}

void CHunter::ProcessAnimation(ICharacterInstance *pCharacter,float frameTime)
{
	if (!pCharacter)
		return;

	//update look ik
	//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(lookTarget,0.25f,ColorB(255,255,0,255));
	//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(GetEntity()->GetWorldPos(), ColorB(255,255,0,255), lookTarget, ColorB(255,255,0,255));
	if (m_grabStats.grabId<1)
		pCharacter->GetISkeleton()->SetLookIK(true,gf_PI*0.9f,m_stats.lookTargetSmooth);
	else
		pCharacter->GetISkeleton()->SetLookIK(false,gf_PI*0.9f,m_stats.lookTargetSmooth);

	//TODO:this is temporary: remove it once the anim sys supports keyframe events
	if (m_IKLimbIndex[0]<0)	m_IKLimbIndex[0] = GetIKLimbIndex("frontLeftTentacle");
	if (m_IKLimbIndex[1]<0)	m_IKLimbIndex[1] = GetIKLimbIndex("frontRightTentacle");
	if (m_IKLimbIndex[2]<0)	m_IKLimbIndex[2] = GetIKLimbIndex("backLeftTentacle");
	if (m_IKLimbIndex[3]<0)	m_IKLimbIndex[3] = GetIKLimbIndex("backRightTentacle");

	int feetOnGround(0);
	Vec3 balancePoint(0,0,0);
	float limit(0);

	for (int i=0;i<4;++i)
	{
		if (m_IKLimbIndex[i]>-1)
		{
			SIKLimb *pLimb = &m_IKLimbs[m_IKLimbIndex[i]];

			//CheckGround(
			//GetEntity()->GetSlotWorldTM(characterSlot) * lAnimPos;
			
			bool stillCheckingZ(false);
			/*CAnimation anim = pCharacter->GetISkeleton()->GetAnimFromFIFO(0,0);

			if (anim.m_nAnimLoop)
			{	
				if (fabs(pLimb->lAnimPos.z)>0.01f && pLimb->lAnimPos.z<m_footLimit[i][0])
				{
					m_footLimit[i][0] = pLimb->lAnimPos.z;
					stillCheckingZ = true;
				}
				if (pLimb->lAnimPos.z>m_footLimit[i][1])
				{
					m_footLimit[i][1] = pLimb->lAnimPos.z;
					stillCheckingZ = true;
				}
			}*/

			if (!stillCheckingZ/* && m_stats.onGround*/)
			{
				//float limit = (m_footLimit[i][0] + m_footLimit[i][1]) * 0.5f;
				limit = m_footLimit[i][0] + (m_footLimit[i][1]-m_footLimit[i][0])*0.5f;
				if (pLimb->lAnimPos.z<limit && pLimb->lAnimPosLast.z>limit)
				{
					//if (m_footSoundTime[i]<0.001f)
					{
						CreateScriptEvent("footstep",i+1);
						m_footSoundTime[i] = 0.35f;
					}

					if (m_stats.onGround)
					{
						Vec3 lPos(pLimb->lAnimPos.x,pLimb->lAnimPos.y,0/*m_footLimit[i][0]*/);
						//FIXME:silly
 						if (i==2 || i==3)
							lPos.z += 0.9f;
						else
							lPos.z += 0.5f;

						m_footGroundPos[i] = GetEntity()->GetSlotWorldTM(pLimb->characterSlot)*lPos;
					}
				}
				//limit = m_footLimit[i][1]*0.5f;
				if (pLimb->lAnimPos.z>limit && pLimb->lAnimPosLast.z<limit)
				{
					if (m_footSoundTime[i]<0.001f)
					{
						CreateScriptEvent("footlift",i+1);
						m_footSoundTime[i] = 0.35f;
					}

					if (m_stats.onGround)
					{
						m_footGroundPos[i].Set(0,0,0);
					}
				}
			}

			if (!m_stats.onGround)
				m_footGroundPos[i].Set(0,0,0);

			Vec3 limbPos(GetEntity()->GetSlotWorldTM(pLimb->characterSlot)*pLimb->lAnimPos);
			Vec3 delta(limbPos - m_footGroundPos[i]);
			delta.z = 0;
			if (delta.len2()>10.0f*10.0f)
				m_footGroundPos[i].Set(0,0,0);// = limbPos;

			bool footOnGround(m_footGroundPos[i].len2()>0.01f);
			
			//debuggage
			//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(limbPos,0.5f,footOnGround?ColorB(255,155,0,255):ColorB(0,255,0,255) );
			//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(GetEntity()->GetSlotWorldTM(pLimb->characterSlot)*Vec3(pLimb->lAnimPos.x,pLimb->lAnimPos.y,limit),0.25f,ColorB(42,155,234,255) );
			if (footOnGround)
			{
				balancePoint += m_footGroundPos[i];
				++feetOnGround;
				//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(limbPos + Vec3(0,0,1), ColorB(255,0,0,255), m_footGroundPos[i] + Vec3(0,0,1), ColorB(255,0,0,255));

				if (m_IKLook || GetISystem()->GetIConsole()->GetCVar("g_hunterIK")->GetIVal())
				//if (m_stats.speedModule<0.1f)
					pLimb->SetWPos(GetEntity(),m_footGroundPos[i],Vec3(0,0,-1)/*ZERO*/,0.25f,0.25f,100);
			}
		}

		m_footSoundTime[i] -= frameTime;
	}

	if (feetOnGround>1)
	{
		balancePoint /= feetOnGround;
		Interpolate(m_balancePoint,balancePoint,1.0,frameTime);
	}
	else
		Interpolate(m_balancePoint,GetEntity()->GetWorldPos(),1.0,frameTime);
	
	//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(m_balancePoint + Vec3(0,0,1), ColorB(255,0,0,255), m_balancePoint + m_modelOffsetAdd + Vec3(0,0,1), ColorB(255,0,0,255));
	//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(m_balancePoint + Vec3(0,0,1),0.5f,ColorB(31,155,213,255));

	Quat currModelQuat(GetEntity()->GetRotation());

	Vec3 mdlright = currModelQuat.GetColumn0();
	Vec3 mldup = m_baseMtx.GetColumn(2);
	Vec3 mdlforward = (mldup % mdlright).GetNormalized();

	Quat goalQuat = GetQuatFromMat33(Matrix33::CreateFromVectors(mdlforward % mldup,mdlforward,mldup));
	goalQuat = Quat::CreateSlerp(currModelQuat, goalQuat, frameTime * 0.5f);

	Vec3 addOffset(0,0,0);

	if (feetOnGround>2 && m_IKLook/*m_stats.speedModule<1.0f*/)
	{		
		float dot(m_viewMtx.GetColumn(1) * goalQuat.GetColumn0());
		/*float color[4] = {1,1,1,1};
		GetISystem()->GetIRenderer()->Draw2dLabel(300,320, 1.5f, color, false,"dot:%.1f", dot);*/

		float maxRotSpeed(0.2f);
		goalQuat *= Quat::CreateRotationZ(min(max(-maxRotSpeed,dot),maxRotSpeed)*frameTime);
		/*mdlright = -m_viewMtx.GetColumn(0);
		mdlforward = (mldup % mdlright).GetNormalized();*/

		addOffset = m_balancePoint - GetEntity()->GetWorldPos();
		addOffset.z = 0;
	}

	Interpolate(m_modelOffsetAdd,addOffset,1.0,frameTime);

	if (m_pAnimatedCharacter)
		m_pAnimatedCharacter->SetEntityRotation(goalQuat);

	if (true)
		return;

	CryCharAnimationParams params;
	params.nLayerID = 0;
	//params.fBlendInTime = params.fBlendOutTime = 0.0f;
	params.nFlags |= CA_RECURSIVE;

	Vec3 forward(m_stats.velocity + m_eyeMtx.GetColumn(1));
	forward.NormalizeSafe();

	Vec3 up(m_baseMtx.GetColumn(2));

	if ((forward-up).len2()>0.001f)
	{
		Vec3 right = (up % forward).GetNormalized();

		float dRotation(gf_PI*0.5f);

		//moving backward?
		Vec3 viewDir(m_viewMtx.GetColumn(1));
		viewDir -= (m_baseMtx * Matrix33::CreateScale(Vec3(0,0,1))) * viewDir;

		viewDir.NormalizeSafe();
		forward.NormalizeSafe();

		float dirDot(forward * viewDir);
		bool goingBack(dirDot<-0.3f);

		if (goingBack)
			dRotation += gf_PI;

		Quat goalQuat(Matrix33::CreateFromVectors(right % up,right,up) * Matrix33::CreateRotationZ(dRotation));

		float rotSpeed = m_params.rotSpeed_min + (1.0f - (max(GetStanceInfo( m_stance )->maxSpeed - max(m_stats.speedModule - m_params.speed_min,0.0f),0.0f) / GetStanceInfo( m_stance )->maxSpeed)) * (m_params.rotSpeed_max - m_params.rotSpeed_min);

		m_modelQuat = Quat::CreateSlerp(GetEntity()->GetRotation().GetNormalized(), goalQuat, frameTime * rotSpeed);
	}

	if (m_pAnimatedCharacter)
	{
		m_pAnimatedCharacter->SetEntityRotation(m_modelQuat);
		/*SCharacterMoveRequest mr;
		mr.type = eCMT_JustRotation;
		mr.turn = GetEntity()->GetRotation().GetInverted() * m_modelQuat;
		m_pAnimatedCharacter->AddMovement(mr);*/
	}
}

void CHunter::UpdateAnimGraph( IAnimationGraphState * pState )
{
	CAlien::UpdateAnimGraph(pState);
	pState->SetInput("ZDelta", m_zDelta);
}

void CHunter::SetFiring(bool fire)
{
	if (fire != m_stats.isFiring)
	{
		if (!m_stats.isFiring)
			CreateScriptEvent("fireWeapon",0);

		m_stats.isFiring = fire;
	}
}

int CHunter::GetBoneID(int ID,int slot) const
{
	if (m_boneIDs[ID]<0)
	{
		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(slot);
		if (!pCharacter)
			return -1;

		char boneStr[64];
		switch(ID)
		{
		case BONE_HEAD:		strcpy(boneStr,"face_bigass_gun");break;
		case BONE_WEAPON: strcpy(boneStr,"face_bigass_gun");break;
		case BONE_EYE_R:	strcpy(boneStr,"face_bigass_gun");break;
		case BONE_EYE_L:	strcpy(boneStr,"face_bigass_gun");break;
		}

		m_boneIDs[ID] = pCharacter->GetISkeleton()->GetIDByName(boneStr);
	}

	return CActor::GetBoneID(ID,slot);
}

void CHunter::GetActorInfo(SAIBodyInfo& bodyInfo)
{
	CAlien::GetActorInfo(bodyInfo);

	int headBoneID = GetBoneID(BONE_HEAD);
	if (headBoneID>-1 && GetEntity()->GetCharacter(0))
	{
		Matrix33 HeadMat(GetEntity()->GetCharacter(0)->GetISkeleton()->GetAbsJMatrixByID(headBoneID));
		bodyInfo.vEyeDir = Matrix33(GetEntity()->GetSlotWorldTM(0) * HeadMat).GetColumn(0);
	}
	
	//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(bodyInfo.vEyePos, ColorB(0,255,0,100), bodyInfo.vEyePos + bodyInfo.vEyeDir * 10.0f, ColorB(255,255,0,100));
}
