/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Implements the Hunter alien.
  
 -------------------------------------------------------------------------
  History:
  - 25:4:2005: Created by Filippo De Luca

*************************************************************************/
#ifndef __HUNTER_H__
#define __HUNTER_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "Alien.h"

class CHunter :
	public CAlien
{
public:

	virtual void Revive(bool fromInit);
	virtual void CreateCodeEvent(SmartScriptTable &rTable);

	virtual void ProcessRotation(float frameTime);
	virtual void ProcessMovement(float frameTime);

	virtual void ProcessAnimation(ICharacterInstance *pCharacter,float frameTime);
	virtual void PostPhysicalize();

	virtual void UpdateFiringDir(float frameTime);

	virtual void	SetActorStance(SOBJECTSTATE &control, int& actions)
	{
		// Empty
	}

	virtual void GetActorInfo( SAIBodyInfo& bodyInfo );

	virtual void SetFiring(bool fire);

	virtual int GetBoneID(int ID,int slot = 0) const;

	virtual bool IsFlying(){return false;}

protected:
	virtual void UpdateAnimGraph( IAnimationGraphState * pState );

	Vec3 m_smoothMovementVec;
	Vec3 m_balancePoint;
	float m_zDelta;

	Quat	m_modelQuat;//the model rotation

	//
	int m_IKLimbIndex[4];
	Vec3 m_footGroundPos[4];

	bool m_IKLook;

	float m_nextStopCheck;

	//TEMPORARY
	float m_footLimit[4][2];
	float m_footSoundTime[4];
};


#endif //__HUNTER_H__
