#ifndef __IPLAYERINPUT_H__
#define __IPLAYERINPUT_H__

#pragma once

#include "IAgent.h" // for EStance
#include "ISerialize.h"
#include "IGameObject.h"

struct SSerializedPlayerInput
{
	EStance stance;
	Vec3 desiredDirection;
	Vec3 lookDirection;
	Vec3 bodyDirection;
	float desiredSpeed;

	SSerializedPlayerInput() :
		stance(STANCE_NULL),
		desiredDirection(FORWARD_DIRECTION),
		lookDirection(FORWARD_DIRECTION),
		desiredSpeed(0.0f)
	{
	}

	void Serialize( TSerialize ser )
	{
		ser.EnumValue( "stance", stance, STANCE_NULL, STANCE_LAST );
		ser.Value( "desiredDirection", desiredDirection );
		ser.Value( "lookDirection", lookDirection );
		ser.Value( "bodyDirection", bodyDirection );
		ser.Value( "desiredSpeed", desiredSpeed );
	}
};

struct IPlayerInput
{
	static const EEntityAspects INPUT_ASPECT = eEA_GameClientDynamic;

	virtual ~IPlayerInput() {};

	virtual void PreUpdate() = 0;
	virtual void Update() = 0;
	virtual void PostUpdate() = 0;

	virtual void OnAction( const ActionId& action, int activationMode, float value ) = 0;

	virtual void SetState( const SSerializedPlayerInput& input ) = 0;
	virtual void GetState( SSerializedPlayerInput& input ) = 0;

	virtual void Reset() = 0;
};

#endif
