// Intensity
// -John Newfield

#pragma once

class CActor;

class CIntensity
{
public:
	CIntensity(CActor *owner);
	~CIntensity(void);
	virtual void Update(float frameTime);
	virtual void ChangeFOV(float goalfov, float time, bool force=false, float baseZoomDiff=0.0f);
	virtual void ModifyFOV(float fov) { m_fGoalFOV = fov; };
	virtual void ModifyBaseZoomTime(float time) { m_fBaseZoomTime = time; };
	virtual float GetStartFOV() { return m_fStartFOV; };
	virtual float GetGoalFOV() { return m_fGoalFOV; };
	virtual float GetBaseZoomTime() { return m_fBaseZoomTime; };
	virtual void Reset();
	virtual void Enable(bool enable);
	virtual float GetCurrentFOV();
	virtual bool Done() { return m_bDone; };
private:
	CActor *m_owner;
	float m_fStartFOV;
	float m_fGoalFOV;
	float m_fBaseZoomTime;
	bool m_bForce;
	bool m_bEnabled;
	bool m_bDone;
	
};

