/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Iron Sight

-------------------------------------------------------------------------
History:
- 28:10:2005   16:00 : Created by Mrcio Martins

*************************************************************************/
#ifndef __IRONSIGHT_H__
#define __IRONSIGHT_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "Weapon.h"
#include "ItemParamReader.h"


#define ResetValue(name, defaultValue) if (defaultInit) name=defaultValue; reader.Read(#name, name)
#define ResetValueEx(name, var, defaultValue) if (defaultInit) var=defaultValue; reader.Read(#name, var)


class CIronSight : public IZoomMode
{
public:
	typedef struct SZoomParams
	{
		SZoomParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);

			ResetValue(layer, "zoom_layer");
			ResetValue(dof, false);
			ResetValue(dof_mask, "");
			ResetValue(sensitivity_ratio, 1.2f);
			ResetValue(hbob_ratio, 1.75f);
			ResetValue(recoil_ratio, 1.0f);

			ResetValue(zoom_in_time, 0.35f);
			ResetValue(zoom_out_time, 0.35f);
			ResetValue(stage_time, 0.055f);

			if (defaultInit)
			{
				stages.resize(0);
				stages.push_back(1.5f);
			}

			if (params)
			{
				const IItemParamsNode *pstages=params->GetChild("stages");
				if (pstages)
				{
					stages.resize(0); 
					int n=pstages->GetChildCount();

					for (int i=0; i<n; i++)
					{
						const IItemParamsNode *stage = pstages->GetChild(i);
						float v = 1.0f; stage->GetAttribute("value", v);
						stages.push_back(v);
					}
				}
			}
		}

		std::vector<float>	stages;
		string							layer;
		bool								dof;
		string							dof_mask;
		float								sensitivity_ratio;
		float								hbob_ratio;
		float								recoil_ratio;
		float								zoom_in_time;
		float								zoom_out_time;
		float								stage_time;

	} SZoomParams;

	typedef struct SZoomActions
	{

		SZoomActions() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(zoom_in,			"zoom_in");
			ResetValue(zoom_out,		"zoom_out");
		}

		string	zoom_in;
		string	zoom_out;

	} SZoomActions;

	CIronSight();
	virtual ~CIronSight();

	// IZoomMode
	virtual void Init(IWeapon *pWeapon, const struct IItemParamsNode *params);
	virtual void Update(float frameTime, uint frameId);
	virtual void Destroy();

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual void Activate(bool activate);

	virtual bool CanZoom() const;
	virtual void StartZoom();
	virtual void StopZoom();
	virtual void ExitZoom();

	virtual void ZoomIn();
	virtual void ZoomOut();

	virtual bool IsZoomed() const;
	virtual bool IsZooming() const;

	virtual void Enable(bool enable);
	virtual bool IsEnabled() const;
	// ~IZoomMode

protected:
	virtual void EnterZoom(float time, const char *zoom_layer=0, bool smooth=true);
	virtual void LeaveZoom(float time, bool smooth=true);

	virtual void ResetTurnOff();
	virtual void TurnOff(bool enable, bool smooth=true, bool anim=true);

	virtual void ZoomIn(float time, float from, float to, bool smooth);
	virtual void ZoomOut(float time, float from, float to, bool smooth);

	virtual void OnEnterZoom();
	virtual void OnZoomedIn();

	virtual void OnLeaveZoom();
	virtual void OnZoomedOut();

	virtual void OnZoomStep(bool zoomingIn, float t);

	virtual void UpdateDepthOfField(float frameTime, float t) {};

	virtual void SetActorFoVScale(float fov, bool sens,bool recoil, bool hbob);
	virtual float GetActorFoVScale() const;

	virtual void SetActorSpeedScale(float scale);
	virtual float GetActorSpeedScale() const;

	virtual float GetSensitivityFromFoVScale(float scale) const;
	virtual float GetHBobFromFoVScale(float scale) const;
	virtual float GetRecoilFromFoVScale(float scale) const;
  
	virtual float GetMagFromFoVScale(float scale) const;
	virtual float GetFoVScaleFromMag(float mag) const;
	virtual float GetZoomFoVScale(int step) const;

	void ClearDoF();

	CWeapon				*m_pWeapon;

  float					m_savedFoVScale;
	
	bool					m_zoomed;
	bool					m_zoomingIn;
	float					m_zoomTimer;
	float					m_zoomTime;
	float					m_focus;

	float					m_startFoV;
	float					m_endFoV;
	bool					m_smooth;
	int						m_currentStep;

	bool					m_enabled;

	SZoomParams		m_zoomparams;
	SZoomActions	m_actions;
};


#endif // __IRONSIGHT_H__