/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 8:9:2005   12:52 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Item.h"
#include "Actor.h"


//------------------------------------------------------------------------
CItem *CItem::AddAccessory(const char *name)
{
	static char namebuf[129];
	_snprintf(namebuf, 128, "%s_%s", GetEntity()->GetName(), name);

	SEntitySpawnParams params;
	params.pClass = m_pEntitySystem->GetClassRegistry()->FindClass(name);
	params.sName = namebuf;
	params.nFlags = ENTITY_FLAG_CLIENT_ONLY | ENTITY_FLAG_NO_PROXIMITY;

	if (!params.pClass)
	{
		GameWarning("Trying to add unknown accessory '%s' to item '%s'!", name, GetEntity()->GetName());
		return 0;
	}

	IEntity *pEntity = m_pEntitySystem->SpawnEntity(params);
	if (pEntity)
	{
		m_accessories.insert(TAccessoryMap::value_type(name, pEntity->GetId()));
		return static_cast<CItem *>(m_pItemSystem->GetItem(pEntity->GetId()));
	}


	return 0;
}

//------------------------------------------------------------------------
void CItem::RemoveAccessory(const char *name)
{
	TAccessoryMap::iterator it = m_accessories.find(name);
	if (it != m_accessories.end())
		m_accessories.erase(it);
	m_pEntitySystem->RemoveEntity(it->second);
}

//------------------------------------------------------------------------
void CItem::AttachAccessory(const char *name, bool attach, bool noanim)
{
	if (IsBusy())
		return;

	bool anim = !noanim && m_stats.fp;
	SAccessoryParams *params = GetAccessoryParams(name);
	if (!params)
		return;
	
	if (attach)
	{
		struct AttachAction: public ISchedulerAction
		{
			AttachAction(CItem *pAccessory, SAccessoryParams *pParams)
				: accessory(pAccessory), params(pParams) {};
			void execute(CItem *item)
			{
				Vec3 position = item->GetSlotHelperPos(eIGS_ThirdPerson, params->attach_helper.c_str(), false);
				item->GetEntity()->AttachChild(accessory->GetEntity());
				Matrix34 tm(Matrix34::CreateIdentity());
				tm.SetTranslation(position);
				accessory->GetEntity()->SetLocalTM(tm);
				accessory->SetParentId(item->GetEntityId());
				item->PlayLayer(params->attach_layer.c_str(), eIPAF_Default|eIPAF_NoBlend);
				item->SetBusy(false);
				item->AccessoriesChanged();
			};

			CItem	*accessory;
			SAccessoryParams *params;
		};

		if (!IsAccessoryHelperFree(params->attach_helper.c_str()))
			return;

		CItem *pAccessory = AddAccessory(name);
		if (!pAccessory)
			return;

		pAccessory->Physicalize(false);
		pAccessory->SetViewMode(m_stats.viewmode);
		
		SetCharacterAttachment(eIGS_FirstPerson, params->attach_helper.c_str(), pAccessory->GetEntity(), eIGS_FirstPerson, 0);
		SetBusy(true);

		AttachAction *action = new AttachAction(pAccessory, params);
		
		if (anim)
		{
			PlayAction(params->attach_action.c_str(), 0, false, eIPAF_Default|eIPAF_NoBlend);
			m_scheduler.TimerAction(GetCurrentAnimationTime(eIGS_FirstPerson), action, false);
		}
		else
			action->execute(this);
	}
	else
	{
		struct DetachAction: public ISchedulerAction
		{
			DetachAction(CItem *pAccessory, SAccessoryParams *pParams)
			: accessory(pAccessory), params(pParams) {};
			void execute(CItem *item)
			{
				item->ResetCharacterAttachment(eIGS_FirstPerson, params->attach_helper.c_str());
				accessory->GetEntity()->DetachThis(0);
				accessory->SetParentId(0);
				item->RemoveAccessory(accessory->GetEntity()->GetClass()->GetName());
				item->SetBusy(false);
				item->AccessoriesChanged();
			};

			CItem	*accessory;
			SAccessoryParams *params;
		};

		CItem *pAccessory = GetAccessory(name);
		if (!pAccessory)
			return;

		DetachAction *action = new DetachAction(pAccessory, params);

		if (anim)
		{
			StopLayer(params->attach_layer.c_str(), eIPAF_Default|eIPAF_NoBlend);
			PlayAction(params->detach_action.c_str(), 0, false, eIPAF_Default|eIPAF_NoBlend);
			m_scheduler.TimerAction(GetCurrentAnimationTime(eIGS_FirstPerson), action, false);
			SetBusy(true);
		}
		else
		{
			SetBusy(true);
			action->execute(this);
		}
	
		
	}
	FixAccessories(params, attach);
}

//------------------------------------------------------------------------
void CItem::AttachAccessoryPlaceHolder(const char *name, bool attach)
{
	const SAccessoryParams *params = GetAccessoryParams(name);
	if (!params)
		return;

	CItem *pPlaceHolder = GetAccessoryPlaceHolder(name);

	if (!pPlaceHolder)
		return;

	if (attach)
	{
		SetCharacterAttachment(eIGS_FirstPerson, params->attach_helper.c_str(), pPlaceHolder->GetEntity(), eIGS_FirstPerson, 0);
		PlayLayer(params->attach_layer, eIPAF_FirstPerson, false);
	}
	else
	{
		ResetCharacterAttachment(eIGS_FirstPerson, params->attach_helper.c_str());
		StopLayer(params->attach_layer, eIPAF_FirstPerson, false);
	}

	ForceSkinning(true);
}

//------------------------------------------------------------------------
CItem *CItem::GetAccessoryPlaceHolder(const char *name)
{
	IInventory *pInventory = GetActorInventory(GetOwnerActor());
	if (!pInventory)
		return 0;

	int slotId = pInventory->FindNextOfClass(name, -1, false);
	if (slotId >= 0)
		return static_cast<CItem *>(m_pItemSystem->GetItem(pInventory->GetItem(slotId)));

	return 0;
}

//------------------------------------------------------------------------
CItem *CItem::GetAccessory(const char *name)
{
	TAccessoryMap::iterator it = m_accessories.find(name);
	if (it != m_accessories.end())
		return static_cast<CItem *>(m_pItemSystem->GetItem(it->second));
	
	return 0;
}

//------------------------------------------------------------------------
CItem::SAccessoryParams *CItem::GetAccessoryParams(const char *name)
{
	TAccessoryParamsMap::iterator it = m_accessoryparams.find(name);
	if (it != m_accessoryparams.end())
		return &it->second;

	return 0;
}

//------------------------------------------------------------------------
bool CItem::IsAccessoryHelperFree(const char *helper)
{
	for (TAccessoryMap::iterator it = m_accessories.begin(); it != m_accessories.end(); it++)
	{
		SAccessoryParams *params = GetAccessoryParams(it->first.c_str());
		
		if (!strcmp(params->attach_helper.c_str(), helper))
			return false;
	}

	return true;
}

//------------------------------------------------------------------------
void CItem::InitialSetup()
{
	for (TInitialSetup::iterator it = m_initialSetup.begin(); it != m_initialSetup.end(); it++)
		AttachAccessory(it->c_str(), true, true);
}

//------------------------------------------------------------------------
void CItem::ReAttachAccessories()
{
	for (TAccessoryMap::iterator it = m_accessories.begin(); it != m_accessories.end(); it++)
		ReAttachAccessory(it->first.c_str());
}

//------------------------------------------------------------------------
void CItem::ReAttachAccessory(const char *name)
{
	CItem *pAccessory = GetAccessory(name);
	SAccessoryParams *params = GetAccessoryParams(name);

	if (pAccessory && params)
	{
		SetCharacterAttachment(eIGS_FirstPerson, params->attach_helper.c_str(), pAccessory->GetEntity(), eIGS_FirstPerson, 0);

		Vec3 position = GetSlotHelperPos(eIGS_ThirdPerson, params->attach_helper.c_str(), false);
		GetEntity()->AttachChild(pAccessory->GetEntity());
		Matrix34 tm(Matrix34::CreateIdentity());
		tm.SetTranslation(position);
		pAccessory->GetEntity()->SetLocalTM(tm);
		pAccessory->SetParentId(GetEntityId());
		PlayLayer(params->attach_layer.c_str(), eIPAF_Default|eIPAF_NoBlend);
	}
}

//------------------------------------------------------------------------
void CItem::AccessoriesChanged()
{
}