/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 6:9:2005   14:13 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Item.h"


//------------------------------------------------------------------------
bool CItem::SupportsDualWield(const char *itemName) const
{
	TDualWieldSupportMap::const_iterator it = m_dualWieldSupport.find(itemName);
	if (it != m_dualWieldSupport.end())
		return true;
	return false;
}

//------------------------------------------------------------------------
void CItem::ResetDualWield()
{
	if (m_dualWieldSlaveId)
	{
		IItem *pSlave = GetDualWieldSlave();
		if (pSlave)
			pSlave->ResetDualWield();
	}

	EnableSelect(true);
	m_dualWieldSlaveId = 0;
	m_dualWieldMasterId = 0;
}

//------------------------------------------------------------------------
IItem *CItem::GetDualWieldSlave() const
{
	return m_pItemSystem->GetItem(m_dualWieldSlaveId);
}


//------------------------------------------------------------------------
EntityId CItem::GetDualWieldSlaveId() const
{
	return m_dualWieldSlaveId;
}

//------------------------------------------------------------------------
IItem *CItem::GetDualWieldMaster() const
{
	return m_pItemSystem->GetItem(m_dualWieldMasterId);
}


//------------------------------------------------------------------------
EntityId CItem::GetDualWieldMasterId() const
{
	return m_dualWieldMasterId;
}


//------------------------------------------------------------------------
bool CItem::IsDualWield() const
{
	return (m_dualWieldSlaveId || m_dualWieldMasterId);
}

//------------------------------------------------------------------------
bool CItem::IsDualWieldSlave() const
{
	return m_dualWieldMasterId != 0;
}

//------------------------------------------------------------------------
bool CItem::IsDualWieldMaster() const
{
	return m_dualWieldSlaveId != 0;
}

//------------------------------------------------------------------------
void CItem::SetDualWieldMaster(EntityId masterId)
{
	m_dualWieldMasterId = masterId;
}

//------------------------------------------------------------------------
void CItem::SetDualWieldSlave(EntityId slaveId)
{
	m_dualWieldSlaveId = slaveId;
	IItem *pSlave = GetDualWieldSlave();
	if (!pSlave)
		return;

	pSlave->EnableSelect(false);
	if (m_stats.hand == eIH_Left)
		pSlave->SetHand(eIH_Right);
	else
		pSlave->SetHand(eIH_Left);
}