/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 7:9:2005   11:24 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Item.h"


//------------------------------------------------------------------------
uint CItem::AttachEffect(int slot, uint id, bool attach, const char *effectName, const char *helper, const Vec3 &offset, const Vec3 &dir, float scale, bool prime)
{
	if (attach)
	{
		if (!i_particleeffects->GetIVal())
			return 0;

		IParticleEffect *pParticleEffect = GetISystem()->GetI3DEngine()->FindParticleEffect(effectName);
		if (!pParticleEffect)
			return 0;

		// generate id
		++m_effectGenId;
		while (!m_effectGenId || (m_effects.find(m_effectGenId) != m_effects.end()))
			++m_effectGenId;
	
		SEntitySlotInfo slotInfo;
		SEffectInfo effectInfo;
		effectInfo.slot = -1;

		bool validSlot = GetEntity()->GetSlotInfo(slot, slotInfo) && (slotInfo.pCharacter || slotInfo.pStatObj);

		if (!validSlot || slotInfo.pStatObj)
		{
			// get helper position
			Vec3 position(0,0,0);
			if (validSlot)
			{
				IStatObj *pStatsObj = slotInfo.pStatObj;
				position = pStatsObj->GetHelperPos(helper);
				position = GetEntity()->GetSlotLocalTM(slot, false).TransformPoint(position);
			}
			position+=offset;

			// find a free slot
			SEntitySlotInfo dummy;
			int i=0;
			while (GetEntity()->GetSlotInfo(eIGS_Last+i, dummy))
				i++;

			// move particle slot to the helper position+offset
			effectInfo.slot = GetEntity()->LoadParticleEmitter(eIGS_Last+i, pParticleEffect, 0, -1, prime);
			Matrix34 tm = IParticleEffect::ParticleLoc(position, dir, scale);
			GetEntity()->SetSlotLocalTM(effectInfo.slot, tm);
			GetEntity()->SetSlotFlags(effectInfo.slot, GetEntity()->GetSlotFlags(effectInfo.slot)|ENTITY_SLOT_RENDER);
		}
		else if (slotInfo.pCharacter)	// bone attachment
		{
			effectInfo.helper = helper;
			effectInfo.characterSlot = slot;
			ICharacterInstance *pCharacter = slotInfo.pCharacter;
			IAttachmentManager *pAttachmentManager = pCharacter->GetIAttachmentManager();
			IAttachment *pAttachment = pAttachmentManager->GetInterfaceByName(helper);

			if (!pAttachment)
			{
				GameWarning("Item '%s' trying to attach effect '%s' to attachment '%s' which does not exist!", GetEntity()->GetName(), effectName, helper);
				return 0;
			}

			CEffectAttachment *pEffectAttachment = new CEffectAttachment(effectName, Vec3(0,0,0), Vec3(0,1,0), scale);
			if (prime)
			{
				pEffectAttachment->CreateEffect();
				pEffectAttachment->GetEmitter()->Prime();
			}

			Matrix34 tm =Matrix34(Matrix33::CreateRotationVDir(dir));
			tm.SetTranslation(offset);
			pAttachment->AddBinding(pEffectAttachment);
			pAttachment->SetRelativeMat(tm);
		}

		m_effects.insert(TEffectInfoMap::value_type(m_effectGenId, effectInfo));
		return m_effectGenId;
	}
	else if (id)
	{
		TEffectInfoMap::iterator it = m_effects.find(id);
		if (it == m_effects.end())
			return 0;

		SEffectInfo &info = it->second;
		if (info.slot>-1)
		{
			GetEntity()->FreeSlot(info.slot);
		}
		else
		{
			ICharacterInstance *pCharacter = GetEntity()->GetCharacter(info.characterSlot);
			if (pCharacter)
			{
				IAttachmentManager *pAttachmentManager = pCharacter->GetIAttachmentManager();
				IAttachment *pAttachment = pAttachmentManager->GetInterfaceByName(info.helper.c_str());

				pAttachment->ClearBinding();
			}
		}
		m_effects.erase(it);
	}

	return 0;
}

//------------------------------------------------------------------------
uint CItem::AttachLight(int slot, uint id, bool attach, float radius, const Vec3 &color, const Vec3 &specular, const char *projectTexture, float projectFov, const char *helper, const Vec3 &offset, const Vec3 &dir)
{
	if (radius<0.1f || !i_lighteffects->GetIVal())
		return 0;

	CDLight light;
	light.m_Color = ColorF(color.x, color.y, color.z, 1.0f);
	light.m_SpecColor = ColorF(specular.x, specular.y, specular.z, 1.0f);
	light.m_nLightStyle = 0;
	light.m_Origin.Set(0,0,0);
	light.m_fLightFrustumAngle = 45.0f;
	light.m_fRadius = radius;
	light.m_fDirectFactor = 1.0f;
	light.m_Flags = DLF_LIGHTSOURCE;
	light.m_NumCM = -1;
	light.m_nEntityLightId = -1;
	light.m_fLifeTime = 0;
	light.m_fLightFrustumAngle = projectFov*0.5f;
	light.m_Flags |= DLF_LMDOT3|DLF_HEATSOURCE;
	light.m_Flags &= ~DLF_TEMP;

	if (projectTexture && strlen(projectTexture))
	{
		int flags = FT_FORCE_CUBEMAP;
		light.m_pLightImage = GetISystem()->GetIRenderer()->EF_LoadTexture(projectTexture, flags, 0);

		if (!light.m_pLightImage || !light.m_pLightImage->IsTextureLoaded())
		{
			GameWarning("Item '%s' failed to load projecting light texture '%s'!", GetEntity()->GetName(), projectTexture);
			return 0;
		}
	}

	if (light.m_fLightFrustumAngle && (light.m_pLightImage != NULL) && light.m_pLightImage->IsTextureLoaded())
		light.m_Flags |= DLF_PROJECT;
	else
	{
		if (light.m_pLightImage)
			light.m_pLightImage->Release();
		light.m_pLightImage = 0;
		light.m_Flags |= DLF_POINT;
	}

	if (attach)
	{
		// generate id
		++m_effectGenId;
		while (!m_effectGenId || (m_effects.find(m_effectGenId) != m_effects.end()))
			++m_effectGenId;

		SEntitySlotInfo slotInfo;
		SEffectInfo effectInfo;
		effectInfo.slot = -1;

		bool validSlot = GetEntity()->GetSlotInfo(slot, slotInfo) && (slotInfo.pCharacter || slotInfo.pStatObj);

		if (!validSlot || slotInfo.pStatObj)
		{
			// get helper position
			Vec3 position(0,0,0);
			if (validSlot)
			{
				IStatObj *pStatsObj = slotInfo.pStatObj;
				position = pStatsObj->GetHelperPos(helper);
				position = GetEntity()->GetSlotLocalTM(slot, false).TransformPoint(position);
			}
			position+=offset;
 
			// find a free slot
			SEntitySlotInfo dummy;
			int i=0;
			while (GetEntity()->GetSlotInfo(eIGS_Last+i, dummy))
				i++;

			// move light slot to the helper position+offset
			effectInfo.slot = GetEntity()->LoadLight(eIGS_Last+i, &light);
			Matrix34 tm = Matrix34(Matrix33::CreateRotationVDir(dir));
			tm.SetTranslation(position);
			GetEntity()->SetSlotLocalTM(effectInfo.slot, tm);
		}
		else if (slotInfo.pCharacter)	// bone attachment
		{
			effectInfo.helper = helper;
			effectInfo.characterSlot = slot;
			ICharacterInstance *pCharacter = slotInfo.pCharacter;
			IAttachmentManager *pAttachmentManager = pCharacter->GetIAttachmentManager();
			IAttachment *pAttachment = pAttachmentManager->GetInterfaceByName(helper);

			if (!pAttachment)
			{
				GameWarning("Item '%s' trying to attach light to attachment '%s' which does not exist!", GetEntity()->GetName(), helper);
				return 0;
			}

			CLightAttachment *pLightAttachment = new CLightAttachment();
			pLightAttachment->LoadLight(light);
			Matrix34 tm =Matrix34(Matrix33::CreateRotationVDir(dir));
			tm.SetTranslation(offset);
			pAttachment->AddBinding(pLightAttachment);
			pAttachment->SetRelativeMat(tm);
		}

		m_effects.insert(TEffectInfoMap::value_type(m_effectGenId, effectInfo));
		return m_effectGenId;
	}
	else if (id)
	{
		TEffectInfoMap::iterator it = m_effects.find(id);
		if (it == m_effects.end())
			return 0;

		SEffectInfo &info = it->second;
		if (info.slot>-1) 
		{
			GetEntity()->FreeSlot(info.slot);
		}
		else
		{
			ICharacterInstance *pCharacter = GetEntity()->GetCharacter(info.characterSlot);
			if (pCharacter)
			{
				IAttachmentManager *pAttachmentManager = pCharacter->GetIAttachmentManager();
				IAttachment *pAttachment = pAttachmentManager->GetInterfaceByName(info.helper.c_str());

				pAttachment->ClearBinding();
			}
		}
		m_effects.erase(it);
	}

	return 0;
}

//------------------------------------------------------------------------
void CItem::SpawnEffect(int slot, const char *effectName, const char *helper, const Vec3 &offset, const Vec3 &dir, float scale)
{
	Vec3 position(0,0,0);

  SEntitySlotInfo slotInfo;
  if (GetEntity()->GetSlotInfo(slot, slotInfo))
  {
    if (slotInfo.pStatObj)	// entity slot
    {
      // get helper position
      IStatObj *pStatsObj = slotInfo.pStatObj;
      position = pStatsObj->GetHelperPos(helper);
    }
    else if (slotInfo.pCharacter)	// bone attachment
    {
      ICharacterInstance *pCharacter = slotInfo.pCharacter;
      IAttachmentManager *pAttachmentManager = pCharacter->GetIAttachmentManager();
      IAttachment *pAttachment = pAttachmentManager->GetInterfaceByName(helper);

      if (pAttachment)
      {
        const Matrix34 m = pAttachment->GetWMatrix();
        position = m.GetTranslation();
      }
      else
      {
        int16 id = pCharacter->GetISkeleton()->GetIDByName(helper);
        if (id>=0)
          position = pCharacter->GetISkeleton()->GetAbsJPositionByID(id);
      }
    }
  }

	position = GetEntity()->GetSlotWorldTM(slot).TransformPoint(position);
	position += offset;

	IParticleEffect *pParticleEffect = GetISystem()->GetI3DEngine()->FindParticleEffect(effectName);
	if (pParticleEffect)
		pParticleEffect->Spawn(true, IParticleEffect::ParticleLoc(position, dir, scale));
}

//------------------------------------------------------------------------
IParticleEmitter *CItem::GetEffectEmitter(uint id) const
{
	TEffectInfoMap::const_iterator it = m_effects.find(id);
	if (it == m_effects.end()) 
		return 0;

	const SEffectInfo &info = it->second;
	SEntitySlotInfo slotInfo;

	if (GetEntity()->GetSlotInfo(info.slot, slotInfo) && slotInfo.pParticleEmitter)
		return slotInfo.pParticleEmitter;

	if (GetEntity()->GetSlotInfo(info.characterSlot, slotInfo) && slotInfo.pCharacter)
	{
		ICharacterInstance *pCharacter = slotInfo.pCharacter;
		IAttachmentManager *pAttachmentManager = pCharacter->GetIAttachmentManager();
		IAttachment *pAttachment = pAttachmentManager->GetInterfaceByName(info.helper.c_str());
		if (pAttachment)
		{
			CEffectAttachment *pEffectAttachment = static_cast<CEffectAttachment *>(pAttachment->GetIAttachmentObject());
			return pEffectAttachment->GetEmitter();
		}
	}

	return 0;
}

//------------------------------------------------------------------------
void CItem::SetEffectWorldTM(uint id, const Matrix34 &tm)
{
	TEffectInfoMap::const_iterator it = m_effects.find(id);
	if (it == m_effects.end()) 
		return;

	const SEffectInfo &info = it->second;
	SEntitySlotInfo slotInfo;

	if (GetEntity()->GetSlotInfo(info.slot, slotInfo) && slotInfo.pParticleEmitter)
	{
		Matrix34 worldMatrix = GetEntity()->GetWorldTM();
		Matrix34 localMatrix = worldMatrix.GetInverted()*tm;

		GetEntity()->SetSlotLocalTM(info.slot, localMatrix);
	}
	else if (GetEntity()->GetSlotInfo(info.characterSlot, slotInfo) && slotInfo.pCharacter)
		SetCharacterAttachmentWorldTM(info.characterSlot, info.helper.c_str(), tm);
}

//------------------------------------------------------------------------
Matrix34 CItem::GetEffectWorldTM(uint id)
{
	TEffectInfoMap::const_iterator it = m_effects.find(id);
	if (it == m_effects.end()) 
		return Matrix34::CreateIdentity();

	const SEffectInfo &info = it->second;
	SEntitySlotInfo slotInfo;

	if (GetEntity()->GetSlotInfo(info.slot, slotInfo) && slotInfo.pParticleEmitter)
		return GetEntity()->GetSlotWorldTM(info.slot);
	else if (GetEntity()->GetSlotInfo(info.characterSlot, slotInfo) && slotInfo.pCharacter)
		return GetCharacterAttachmentWorldTM(info.characterSlot, info.helper.c_str());

	return Matrix34::CreateIdentity();
}