/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 5:9:2005   14:55 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Item.h"


//------------------------------------------------------------------------
void CItem::OnStartUsing()
{
}

//------------------------------------------------------------------------
void CItem::OnStopUsing()
{
}

//------------------------------------------------------------------------
void CItem::OnSelect(bool select)
{
}

//------------------------------------------------------------------------
void CItem::OnSelected(bool selected)
{
}
;
//------------------------------------------------------------------------
void CItem::OnEnterFirstPerson()
{
	EnableUpdate(true);
	EnableHiddenSkinning(true);
	SetViewMode(eIVM_FirstPerson);
	AttachToHand(false);
	AttachArms(true);

	ForceSkinning(false);
	RestoreLayers();
}

//------------------------------------------------------------------------
void CItem::OnEnterThirdPerson()
{
	EnableHiddenSkinning(false);
	SetViewMode(eIVM_ThirdPerson);
	AttachToHand(true);
	AttachArms(false);
}

//------------------------------------------------------------------------
void CItem::OnReset()
{
	if (m_stats.used)
		StopUse(m_ownerId);

	int pickable = 1;
	int mounted = 0;
	GetEntityProperty("bPickable", pickable);
	GetEntityProperty("bMounted", mounted);

	if (m_stats.dropped && !pickable && !mounted)
	{
		m_pEntitySystem->RemoveEntity(GetEntityId());
		Hide(true);
		return;
	}

	if (mounted && m_params.mountable)
	{
		MountAt(GetEntity()->GetWorldPos());

		SetViewMode(eIVM_FirstPerson);

		if (m_stats.mounted)
		{
			SEntityPhysicalizeParams params;
			params.mass = 0;
			params.nSlot = -1;
			params.type = PE_STATIC;
			GetEntity()->Physicalize(params);
		}
	}
	else
	{
		SetViewMode(eIVM_ThirdPerson);

		if (pickable)
		{
			Physicalize(true);
			Pickalize(true, false);
		}
		else
		{
			int physics = 1;
			GetEntityProperty("bPhysics", physics);
			Physicalize(physics!=0);
		}
	}
}