/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 1:9:2005   11:32 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "ItemScheduler.h"
#include "Item.h"
#include "Game.h"
#include "IGameObject.h"


//------------------------------------------------------------------------
CItemScheduler::CItemScheduler(CItem *item)
: m_busy(false),
	m_pTimer(0),
	m_pItem(item)
{
	m_pTimer = GetISystem()->GetITimer();
}

//------------------------------------------------------------------------
CItemScheduler::~CItemScheduler()
{
	Reset();
}

//------------------------------------------------------------------------
void CItemScheduler::Reset()
{
	for (TTimerActionVector::iterator it = m_timers.begin(); it != m_timers.end(); it++)
		delete it->action;
	for (TScheduledActionVector::iterator it = m_schedule.begin(); it != m_schedule.end(); it++)
		delete it->action;
	
	m_timers.resize(0);
	m_schedule.resize(0);
}

//------------------------------------------------------------------------
void CItemScheduler::Update(float frameTime)
{
	if (frameTime > 0.2f)
		frameTime = 0.2f;

	if (!m_schedule.empty())
	{
		while(!m_schedule.empty() && !m_busy)
		{
			SScheduledAction &action = *m_schedule.begin();
			action.action->execute(m_pItem);
			delete action.action;
			m_schedule.erase(m_schedule.begin());
		}
	}

	if (!m_timers.empty())
	{
		uint count=0;
		m_actives.swap(m_timers);

		for (TTimerActionVector::iterator it = m_actives.begin(); it != m_actives.end(); it++)
		{
			STimerAction &action = *it;
			action.time -= frameTime;
			if (action.time <= 0.0f)
			{
				action.action->execute(m_pItem);
				delete action.action;
				++count;
			}
		}

		if (count)
			m_actives.erase(m_actives.begin(), m_actives.begin()+count);

		if (!m_timers.empty())
		{
			for (TTimerActionVector::iterator it=m_timers.begin(); it!=m_timers.end(); ++it)
				m_actives.push_back(*it);

			std::sort(m_actives.begin(), m_actives.end(), compare_timers());
		}

		m_actives.swap(m_timers);
		m_actives.resize(0);
	}

	if (m_timers.empty() && m_schedule.empty())
		m_pItem->GetGameObject()->DisableUpdateSlot( m_pItem, eIUS_Scheduler );
}

//------------------------------------------------------------------------
void CItemScheduler::ScheduleAction(ISchedulerAction *action)
{
	if (!m_busy)
	{
		action->execute(m_pItem);
		return;
	}

	SScheduledAction scheduleAction;
	scheduleAction.action = action;

	m_schedule.push_back(scheduleAction);

	m_pItem->GetGameObject()->EnableUpdateSlot( m_pItem, eIUS_Scheduler );
}

//------------------------------------------------------------------------
void CItemScheduler::TimerAction(uint time, ISchedulerAction *action, bool persistent)
{
	STimerAction timerAction;
	timerAction.action = action;
	timerAction.time = (float)time/1000.0f;

	m_timers.push_back(timerAction);
	std::sort(m_timers.begin(), m_timers.end(), compare_timers());

	m_pItem->GetGameObject()->EnableUpdateSlot( m_pItem, eIUS_Scheduler );
}

//------------------------------------------------------------------------
bool CItemScheduler::IsBusy()
{
	return m_busy;
}

//------------------------------------------------------------------------
void CItemScheduler::SetBusy(bool busy)
{
	m_busy = busy;
}
