/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Item Scheduler

-------------------------------------------------------------------------
History:
- 1:9:2005   11:33 : Created by Mrcio Martins

*************************************************************************/
#ifndef __ITEMSCHEDULER_H__
#define __ITEMSCHEDULER_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <vector>
#include <ITimer.h>


class CItem;
struct ISchedulerAction
{
	virtual void execute(CItem *_this) = 0;
};


class CItemScheduler
{
	typedef struct SScheduledAction
	{
		ISchedulerAction	*action;
	};
	typedef struct STimerAction
	{
		ISchedulerAction	*action;
		float							time;
	};

	typedef std::vector<STimerAction>									TTimerActionVector;
	typedef std::vector<SScheduledAction>							TScheduledActionVector;

	struct compare_timers
	{
		bool operator() (const STimerAction &lhs, const STimerAction &rhs ) const
		{
			return lhs.time < rhs.time;
		}
	};

public:
	CItemScheduler(CItem *item);
	virtual ~CItemScheduler();
	void Reset();
	void Update(float frameTime);
	void TimerAction(uint time, ISchedulerAction *action, bool persistent);
	void ScheduleAction(ISchedulerAction *action);

	bool IsBusy();
	void SetBusy(bool busy);

private:
	bool				m_busy;
	ITimer			*m_pTimer;
	CItem				*m_pItem;

	TTimerActionVector				m_timers;
	TTimerActionVector				m_actives;
	TScheduledActionVector		m_schedule;
};



#endif //__ITEMSCHEDULER_H__