/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 30:8:2005   12:52 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Item.h"
#include "Actor.h"
#include "Player.h"
#include "Alien.h"

#include "ICryAnimation.h"


//------------------------------------------------------------------------
void CItem::UpdateFPView(float frameTime)
{
	CheckViewChange();

	if (!m_stats.fp)
		return;
	
	if (!m_stats.mounted)
	{
		CryCharAnimationParams params;
		params.nLayerID = 0;
		//params.fBlendInTime = 0;
		//params.fBlendOutTime = 0;

		CActor* pActor = GetOwnerActor();
		if (!pActor)
			return;

		SPlayerStats *pStats = static_cast<SPlayerStats *>(pActor->GetActorStats());
		if (!pStats)
			return;

		Matrix34 tm = Matrix33(Quat::CreateRotationXYZ(pStats->FPWeaponAngles));

		Vec3 offset(0.0f,0.0f,0.0f);

		float right = i_offset_right->GetFVal();
		float front = i_offset_front->GetFVal();
		float up = i_offset_up->GetFVal();

		if (front!=0.0f || up!=0.0f || right!=0.0f)
		{
			offset += tm.GetColumn(0).GetNormalized()*(right+m_dummyOffset.x);
			offset += tm.GetColumn(1).GetNormalized()*(front+m_dummyOffset.y);
			offset += tm.GetColumn(2).GetNormalized()*(up+m_dummyOffset.z);
		}

		tm.SetTranslation(pStats->FPWeaponPos+offset);
		GetEntity()->SetWorldTM(tm);
	}

	if (IsClient())
	{
		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(eIGS_FirstPerson);

		if (pCharacter && pCharacter->GetISkeleton()->GetNumAnimsInFIFO(0)<1)
			PlayAction(m_idleAnimation[eIGS_FirstPerson].c_str(), 0, true);
	}

	// need to explicitly update characters at this point
	// cause the entity system update occered earlier, with the last position
	for (int i=0; i<eIGS_Last; i++)
	{
		if (GetEntity()->GetSlotFlags(i)&ENTITY_SLOT_RENDER)
		{
			ICharacterInstance *pCharacter = GetEntity()->GetCharacter(i);
			if (pCharacter)
			{
				pCharacter->Update(GetEntity()->GetWorldTM()*GetEntity()->GetSlotLocalTM(i, false), GetISystem()->GetViewCamera());
				pCharacter->ForceUpdate(GetEntity()->GetWorldTM()*GetEntity()->GetSlotLocalTM(i, false), 1);
			}
		}
	}

	IEntityRenderProxy *pProxy=GetRenderProxy();
	if (pProxy)
		pProxy->InvalidateLocalBounds();

	if (IItem *pSlave = GetDualWieldSlave())
		pSlave->UpdateFPView(frameTime);

	if (m_stats.mounted)
		UpdateMounted(frameTime);
}

//------------------------------------------------------------------------
bool CItem::IsOwnerFP()
{
	CActor *pOwner = GetOwnerActor();
	if (!pOwner)
		return false;

	if (m_pGameFramework->GetClientActor() != pOwner)
		return false;

	return !pOwner->IsThirdPerson();
}

//------------------------------------------------------------------------
bool CItem::IsCurrentItem()
{
	CActor *pOwner = GetOwnerActor();
	if (!pOwner)
		return false;

	IInventory *pInventory = GetActorInventory(pOwner);
	if (pInventory && pInventory->GetCurrentItem() == GetEntityId())
		return true;

	return false;
}

//------------------------------------------------------------------------
void CItem::UpdateMounted(float frameTime)
{
	if (!m_ownerId || !m_stats.mounted)
		return;

	CActor *pActor = GetOwnerActor();
	if (!pActor)
		return;

	CheckViewChange();

  if (pActor->GetLinkedVehicle())
    return;

	if (IsClient())
	{
		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(eIGS_FirstPerson);
		//if (pCharacter && pCharacter->GetCurrentAnimation(0)<0)
		//	PlayAction(m_idleAnimation[eIGS_FirstPerson].c_str(), 0, true);
		//changed by ivo: if there are problems please contact me
		if (pCharacter)
			PlayAction(m_idleAnimation[eIGS_FirstPerson].c_str(), 0, true);
	}

	// need to explicitly update characters at this point
	// cause the entity system update occered earlier, with the last position
	for (int i=0; i<eIGS_Last; i++)
	{
		if (GetEntity()->GetSlotFlags(i)&ENTITY_SLOT_RENDER)
		{
			ICharacterInstance *pCharacter = GetEntity()->GetCharacter(i);
			if (pCharacter)
			{
				pCharacter->Update(GetEntity()->GetWorldTM()*GetEntity()->GetSlotLocalTM(i, false), GetISystem()->GetViewCamera());
				pCharacter->ForceUpdate(GetEntity()->GetWorldTM()*GetEntity()->GetSlotLocalTM(i, false), 1);
			}
		}
	}

	if (IMovementController * pMC = pActor->GetMovementController())
	{
		SMovementState info;
		pMC->GetMovementState(info);

    Vec3 dir = info.aimDirection.GetNormalized();

		Matrix34 tm = Matrix34(Matrix33::CreateRotationVDir(dir));
		tm.SetTranslation(GetEntity()->GetWorldPos());

		GetEntity()->SetWorldTM(tm);
		
		float	dist = m_mountparams.eye_distance;

		Vec3 oldp = pActor->GetEntity()->GetWorldPos();
		Vec3 newp = GetEntity()->GetWorldPos()-dir*dist;
		newp.z = oldp.z;

		Matrix34 actortm = pActor->GetEntity()->GetWorldTM();
		actortm.SetTranslation(newp);
		pActor->GetEntity()->SetWorldTM(actortm, ENTITY_XFORM_USER);
	}

	if (!m_mountparams.left_hand_helper.empty() || !m_mountparams.right_hand_helper.empty())
	{
		Vec3 lhpos=GetSlotHelperPos(eIGS_FirstPerson, m_mountparams.left_hand_helper.c_str(), true);
		Vec3 rhpos=GetSlotHelperPos(eIGS_FirstPerson, m_mountparams.right_hand_helper.c_str(), true);
		pActor->SetIKPos("leftArm", lhpos, 1);
		pActor->SetIKPos("rightArm", rhpos, 1);
	}
}

//------------------------------------------------------------------------
void CItem::CheckViewChange()
{
  CActor *pOwner = GetOwnerActor();
    
	if (m_stats.mounted && (!pOwner || !pOwner->GetLinkedVehicle()))
	{
		if (!m_stats.fp || !(m_stats.viewmode&eIVM_FirstPerson))
			OnEnterFirstPerson();

		m_stats.fp = true;
		return;
	}

  if (!pOwner)
    return;

	if (!pOwner->IsThirdPerson())
	{
		if (!m_stats.fp || !(m_stats.viewmode&eIVM_FirstPerson))
			OnEnterFirstPerson();
		m_stats.fp = true;
	}
	else
	{
		if (m_stats.fp || !(m_stats.viewmode&eIVM_ThirdPerson))
			OnEnterThirdPerson();
		m_stats.fp = false;
	}
}

//------------------------------------------------------------------------
void CItem::SetViewMode(int mode)
{
	if ((mode & eIVM_FirstPerson) && !m_parentId)
	{
		uint flags = GetEntity()->GetFlags();
		if (!m_stats.mounted)
			flags &= ~ENTITY_FLAG_CASTSHADOW;
		else
			flags |= ENTITY_FLAG_CASTSHADOW;

		GetEntity()->SetFlags(flags|ENTITY_FLAG_RECVSHADOW);
		DrawSlot(eIGS_FirstPerson, true, !m_stats.mounted);

		IEntityRenderProxy *pRenderProxy = GetRenderProxy();

		if(pRenderProxy)
			pRenderProxy->SetGBufferId(0);		// set GBuffer value (0=nearest)
	}
	else
	{
		DrawSlot(eIGS_FirstPerson, false);

		IEntityRenderProxy *pRenderProxy = GetRenderProxy();

		if(pRenderProxy)
			pRenderProxy->SetGBufferId(128);		// set defaul GBuffer value 
	}

	if (mode & eIVM_ThirdPerson)
	{
		DrawSlot(eIGS_ThirdPerson, true);
		if (!m_stats.mounted)
			CopyRenderFlags(GetOwner());
	}
	else
	{
		DrawSlot(eIGS_ThirdPerson, false);
	}

	m_stats.viewmode = mode;


	for (TAccessoryMap::iterator it = m_accessories.begin(); it != m_accessories.end(); it++)
	{
		IItem *pItem = m_pGameFramework->GetIItemSystem()->GetItem(it->second);
		if (pItem)
		{
			CItem *pCItem = static_cast<CItem *>(pItem);
			if (pCItem)
				pCItem->SetViewMode(mode);
		}
	}
}

//------------------------------------------------------------------------
void CItem::ResetRenderFlags()
{
	if (!GetRenderProxy())
		return;

	IRenderNode *pRenderNode = GetRenderProxy()->GetRenderNode();
	if (pRenderNode)
	{
		pRenderNode->SetViewDistRatio(127);
		pRenderNode->SetLodRatio(127);
		GetEntity()->SetFlags(GetEntity()->GetFlags()|ENTITY_FLAG_RECVSHADOW|ENTITY_FLAG_CASTSHADOW);	
	}
}

//------------------------------------------------------------------------
void CItem::CopyRenderFlags(IEntity *pOwner)
{
	if (!pOwner || !GetRenderProxy())
		return;

	IRenderNode *pRenderNode = GetRenderProxy()->GetRenderNode();
	if (pRenderNode)
	{
		IEntityRenderProxy *pOwnerRenderProxy = (IEntityRenderProxy *)pOwner->GetProxy(ENTITY_PROXY_RENDER);
		IRenderNode *pOwnerRenderNode = pOwnerRenderProxy?pOwnerRenderProxy->GetRenderNode():NULL;
		if (pOwnerRenderNode)
		{
			pRenderNode->SetViewDistRatio(pOwnerRenderNode->GetViewDistRatio());
			pRenderNode->SetLodRatio(pOwnerRenderNode->GetLodRatio());

			uint flags = pOwner->GetFlags()&(ENTITY_FLAG_RECVSHADOW|ENTITY_FLAG_CASTSHADOW);
			uint mflags = GetEntity()->GetFlags()&(~(ENTITY_FLAG_RECVSHADOW|ENTITY_FLAG_CASTSHADOW));
			GetEntity()->SetFlags(mflags|flags);
		}
	}
}
