/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Implements the Nanosuit.
  
 -------------------------------------------------------------------------
  History:
  - 22:11:2005: Created by Filippo De Luca
	- 31:01:2006: Modified & adopted to new HUD by Jan Mller

*************************************************************************/
#ifndef __NANOSUIT_H__
#define __NANOSUIT_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "ISound.h"

enum ENanoSlot
{
	NANOSLOT_ARMOR = 0,
	NANOSLOT_SPEED,
	NANOSLOT_STRENGTH,
	NANOSLOT_MEDICAL,
	//
	NANOSLOT_LAST
};

struct SNanoSlot
{
	char name[32];
	float desiredVal;
	float realVal;
};

struct SNanoConfig
{
	float m_desiredVal[NANOSLOT_LAST];
	string m_name;

	SNanoConfig()
	{
		m_desiredVal[NANOSLOT_ARMOR] = 50; m_desiredVal[NANOSLOT_SPEED] = 50; m_desiredVal[NANOSLOT_STRENGTH] = 50; m_desiredVal[NANOSLOT_MEDICAL] = 50;
	}

	void Save(const SNanoSlot slots[NANOSLOT_LAST])
	{
		m_desiredVal[NANOSLOT_ARMOR] = slots[NANOSLOT_ARMOR].desiredVal; m_desiredVal[NANOSLOT_SPEED] = slots[NANOSLOT_SPEED].desiredVal;
		m_desiredVal[NANOSLOT_STRENGTH] = slots[NANOSLOT_STRENGTH].desiredVal; m_desiredVal[NANOSLOT_MEDICAL] = slots[NANOSLOT_MEDICAL].desiredVal;
	}

	void Load(SNanoSlot slots[NANOSLOT_LAST]) const
	{
		slots[NANOSLOT_ARMOR].desiredVal = m_desiredVal[NANOSLOT_ARMOR]; slots[NANOSLOT_SPEED].desiredVal = m_desiredVal[NANOSLOT_SPEED];
		slots[NANOSLOT_STRENGTH].desiredVal = m_desiredVal[NANOSLOT_STRENGTH]; slots[NANOSLOT_MEDICAL].desiredVal = m_desiredVal[NANOSLOT_MEDICAL];
	}
};

enum ENanoSound
{
	SPEED_SOUND = 0,
	STRENGTH_SOUND,
	MEDICAL_SOUND
};

class CPlayer;

class CNanoSuit
{
public:

	CNanoSuit();
	~CNanoSuit();

	void Activate(bool activate){m_active = activate;}
  bool IsActive() const { return m_active; }
	void Reset(CPlayer *owner);
	void Update(CPlayer *owner,float frameTime);
	void UpdateHUD();
	void Serialize( TSerialize ser, unsigned aspects );
	//receives hud-events

	//setting
	void SetEnergy(float value);
	void SetAllSlots(float armor, float strength, float speed);
	//getting
	float GetSlotValue(int slot,bool desired=false) const;
	float GetUsedEnergy();
	bool	GetSoundIsPlaying(ENanoSound sound) const;
	ILINE float GetSuitEnergy(){return m_energy;}
	ILINE float GetSuitHealthRechargeBar() { return m_healthRechargeBar; }
	ILINE float GetHealthRegenAdjuster() { return m_healthRegenAdjuster; }

	ILINE void SaveConfig()
	{ 
		m_iLastSaved++;
		if(m_iLastSaved > 2)
			m_iLastSaved = 0;

		m_savedConfigs[m_iLastSaved].Save(m_slots);
	}

	ILINE void LoadConfig()
	{ 
		m_savedConfigs[m_iLastSaved].Load(m_slots); 
		m_iLastSaved--;
		if(m_iLastSaved < 0)
			m_iLastSaved = 2;
	}

	ILINE int GetOwnerHealth()
	{
		return (int)m_healthMin;
	}

	ILINE void SwitchCloaked()
	{
		m_bCloaked = !m_bCloaked;
	}

	ILINE bool GetCloaked() const
	{
		return m_bCloaked;
	}

	ILINE void SetStrengthUsed()
	{
		m_bStrengthUsed = true;
		PlaySound(STRENGTH_SOUND);
	}

	ILINE void ResetEnergy()
	{
		m_energy = 200.0f;
		for(int i = 0; i < NANOSLOT_LAST; i++)
			m_slots[i].realVal = m_slots[i].desiredVal;
		m_deltaEnergy = 0.0f;
	}

	void PlaySound(ENanoSound sound);

private:

	int IDByName(char *slotStr);
	void Balance(float energy);

private:

	EntityId m_ownerId;

	bool m_active;

	float m_energy;
	float m_deltaEnergy;
	float m_rechargeRate;//% per seconds
	float m_rechargeAdjuster;
	bool  m_bStrengthUsed;
	float m_healthRechargeBar;
	float m_healthMin;
	float m_healthRegenAdjuster;

	bool m_bCloaked;

	SNanoSlot m_slots[NANOSLOT_LAST];
	SNanoConfig m_savedConfigs[3];
	int			m_iLastSaved;

	//sound playback
	float		m_fLastSoundPlayedMedical;
	_smart_ptr<ISound> m_pSprintSound;
	_smart_ptr<ISound> m_pStrengthSound;
	_smart_ptr<ISound> m_pMedicalSound;
};

#endif //__NANOSUIT_H__
