#include "StdAfx.h"
#include "NetPlayerInput.h"
#include "Player.h"

CNetPlayerInput::CNetPlayerInput( CPlayer * pPlayer ) : m_pPlayer(pPlayer)
{
}

void CNetPlayerInput::PreUpdate()
{
}

void CNetPlayerInput::Update()
{
}

void CNetPlayerInput::PostUpdate()
{
}

void CNetPlayerInput::SetState( const SSerializedPlayerInput& input )
{
	m_curInput = input;

	IPhysicalEntity * pPhysEnt = m_pPlayer->GetEntity()->GetPhysics();
	pe_status_pos posStatus;
	pPhysEnt->GetStatus( &posStatus );

	CMovementRequest moveRequest;
	moveRequest.SetStance( m_curInput.stance );
	moveRequest.SetMoveTarget( posStatus.pos + m_curInput.desiredDirection );
	moveRequest.SetLookTarget( posStatus.pos + m_curInput.lookDirection );
	moveRequest.SetDesiredSpeedAtTarget( m_curInput.desiredSpeed );
	moveRequest.SetDesiredBodyDirectionAtTarget( m_curInput.bodyDirection );
	m_pPlayer->GetMovementController()->RequestMovement(moveRequest);

	m_pPlayer->GetGameObject()->ChangedNetworkState( INPUT_ASPECT );
}

void CNetPlayerInput::GetState( SSerializedPlayerInput& input )
{
	input = m_curInput;
}

void CNetPlayerInput::Reset()
{
}
