/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 11:9:2005   15:00 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Plant.h"
#include "Item.h"
#include "Weapon.h"
#include "Projectile.h"
#include "Actor.h"
#include "Game.h"



//------------------------------------------------------------------------
CPlant::CPlant()
{
}

//------------------------------------------------------------------------
CPlant::~CPlant()
{
}

//------------------------------------------------------------------------
void CPlant::Update(float frameTime, uint frameId)
{
	CSingle::Update(frameTime, frameId);

	if (m_plantTimer>0.0f)
	{
		m_plantTimer -= frameTime;
		if (m_plantTimer<=0.0f)
		{
			m_plantTimer = 0.0f;
			if (m_firing)
			{
				DoPlant();
			}
		}
	}

	if (m_plantparams.timed && m_holding)
	{
		if (m_tickTimer>0.0f)
		{
			m_tickTimer-=frameTime;
			if (m_tickTimer<=0.0f)
				DoTick();
		}
	}

	if (!m_pressing && m_holding)
	{
		struct ReleaseButtonAction: public ISchedulerAction
		{
			ReleaseButtonAction(CPlant *_plant): pplant(_plant) {};
			CPlant *pplant;

			virtual void execute(CItem *_this)
			{
				pplant->m_startplant = true;
			}
		};

		m_holding = false;
		m_pWeapon->PlayAction(m_plantactions.release_button.c_str());
		m_pWeapon->GetScheduler()->TimerAction(m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson), new ReleaseButtonAction(this), false);			
	}

	if (m_startplant)
		StartPlant();
}

//------------------------------------------------------------------------
void CPlant::ResetParams(const struct IItemParamsNode *params)
{
	CSingle::ResetParams(params);

	const IItemParamsNode *plant = params?params->GetChild("plant"):0;
	const IItemParamsNode *actions = params?params->GetChild("actions"):0;
	m_plantparams.Reset(plant, true);
	m_plantactions.Reset(actions, true);
}

//------------------------------------------------------------------------
void CPlant::PatchParams(const struct IItemParamsNode *patch)
{
	CSingle::PatchParams(patch);

	const IItemParamsNode *plant = patch?patch->GetChild("plant"):0;
	const IItemParamsNode *actions = patch?patch->GetChild("actions"):0;
	m_plantparams.Reset(plant, false);
	m_plantactions.Reset(actions, false);
}

//------------------------------------------------------------------------
void CPlant::Activate(bool activate)
{
	CSingle::Activate(activate);

	m_plantTimer = 0.0f;
	m_pressing = false;
	m_holding = false;
	m_startplant = false;

	m_time = m_plantparams.min_time;
	m_tickTimer = 0.0f;

	SetLED(m_time, m_plantparams.led_minutes, m_plantparams.led_layers.c_str());

	CheckAmmo();
}

//------------------------------------------------------------------------
bool CPlant::CanReload() const
{
	return false;
}

//------------------------------------------------------------------------
bool CPlant::IsReadyToFire() const
{
	return CanFire(true);
}

//------------------------------------------------------------------------
void CPlant::StartFire(EntityId shooterId)
{
	if (m_plantparams.timed)
	{
		if (CanFire(true) && !m_pressing && !m_holding && !m_pWeapon->IsBusy())
		{
			struct PressButtonAction: public ISchedulerAction
			{
				PressButtonAction(CPlant *_plant): pplant(_plant) {};
				CPlant *pplant;

				virtual void execute(CItem *_this)
				{
					pplant->m_holding = true;
					pplant->m_pWeapon->PlayAction(pplant->m_plantactions.hold_button.c_str(), 0, true, CItem::eIPAF_Default|CItem::eIPAF_NoBlend);

					pplant->DoTick();
				}
			};
			m_pressing = true;
			m_pWeapon->SetBusy(true);
			m_pWeapon->PlayAction(m_plantactions.press_button.c_str());
			m_pWeapon->GetScheduler()->TimerAction(m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson), new PressButtonAction(this), false);
		}
	}
	else
	{
		if (CanFire(true))
			StartPlant();
	}
}

//------------------------------------------------------------------------
void CPlant::StopFire(EntityId shooterId)
{
	m_pressing=false;
}

//------------------------------------------------------------------------
float CPlant::GetTime()
{
	return m_time;
}

//------------------------------------------------------------------------
void CPlant::CheckAmmo()
{
	m_pWeapon->HideItem(!m_pWeapon->GetAmmoCount(m_fireparams.ammo_type.c_str()) && m_plantparams.hide_ammo);
}

//------------------------------------------------------------------------
void CPlant::DoTick()
{
	m_tickTimer = m_plantparams.tick_time;
	m_time += m_plantparams.tick;

	if (m_time>m_plantparams.max_time)
		m_time = m_plantparams.min_time;

	m_pWeapon->PlayAction(m_plantactions.tick.c_str());

	SetLED(m_time, m_plantparams.led_minutes, m_plantparams.led_layers.c_str());
}

//------------------------------------------------------------------------
void CPlant::DoPlant()
{
	const char *ammo = m_fireparams.ammo_type.c_str();
	int ammoCount = m_pWeapon->GetAmmoCount(ammo);

	Vec3 pos;
	Vec3 dir(FORWARD_DIRECTION);
	Vec3 vel(0,0,0);

	if (m_pWeapon->GetStats().fp)
	{
		pos = m_pWeapon->GetSlotHelperPos(CItem::eIGS_FirstPerson, m_plantparams.helper.c_str(), true);
		m_pWeapon->HideItem(true);
	}
	else
		pos = m_pWeapon->GetEntity()->GetWorldPos();

	CActor *pActor = m_pWeapon->GetOwnerActor();
	IMovementController *pMC = pActor?pActor->GetMovementController():0;
	if (pMC)
	{
		SMovementState info;
		pMC->GetMovementState(info);
		dir = info.eyeDirection;
	}

	CProjectile *pAmmo = m_pWeapon->SpawnAmmo(ammo);
	if (pAmmo)
	{
		pAmmo->SetParams(m_shooterId, m_pWeapon->GetEntity()->GetId(), m_fireparams.damage);
		pAmmo->SetDestination(m_pWeapon->GetDestination());
		pAmmo->Launch(pos+dir*0.5, dir, vel);

		if (m_plantparams.timed)
			pAmmo->GetEntity()->SetTimer(CProjectile::ePTIMER_LIFETIME, (int)(GetTime()*1000));
		else
			pAmmo->GetEntity()->KillTimer(CProjectile::ePTIMER_LIFETIME);

		m_projectileId = pAmmo->GetEntity()->GetId();
	}

	m_pWeapon->OnShoot(m_shooterId, pAmmo?pAmmo->GetEntity()->GetId():0, GetAmmoType(), pos, dir, vel);

	ammoCount--;
	m_pWeapon->SetAmmoCount(ammo, ammoCount);
}

//------------------------------------------------------------------------
void CPlant::SetLED(float time, bool minutes, const char *layerFmt)
{
	int d[3]={0};

	if (minutes)
	{
		int secs = (int)time%60;
		d[2] = (int)(time/60);
		d[1] = secs/10;
		d[0] = secs%10;
	}
	else
	{
		d[2] = (int)(time/100);
		d[1] = ((int)time%100)/10;
		d[0] = (((int)time%100)/10)%10;
	}

	string layer;
	for (int i=0;i<3;i++)
	{
		layer.Format(layerFmt, i+1, d[i]);
		m_pWeapon->PlayLayer(layer.c_str(), CItem::eIPAF_Default|CItem::eIPAF_NoBlend, true);
	}
}

//------------------------------------------------------------------------
void CPlant::StartPlant()
{
	m_firing = true;
	m_startplant = false;
	m_pWeapon->SetBusy(true);
	m_pWeapon->PlayAction(m_actions.fire.c_str());
	m_plantTimer = m_plantparams.delay;

	struct StartPlantAction: public ISchedulerAction
	{
		StartPlantAction(CPlant *_plant): pplant(_plant) {};
		CPlant *pplant;

		virtual void execute(CItem *_this)
		{
			pplant->m_pWeapon->SetBusy(false);
			pplant->m_firing = false;

			if (pplant->m_plantparams.timed)
			{
				pplant->m_pWeapon->PlayAction("select", 0, false, CItem::eIPAF_Default|CItem::eIPAF_NoBlend);
				pplant->m_time = pplant->m_plantparams.min_time;

				pplant->CheckAmmo();
				pplant->SetLED(pplant->m_time, pplant->m_plantparams.led_minutes, pplant->m_plantparams.led_layers.c_str());
			}
			else
				pplant->SelectDetonator();
		}
	};
	m_pWeapon->GetScheduler()->TimerAction(m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson), new StartPlantAction(this), false);
}

//------------------------------------------------------------------------
void CPlant::SelectDetonator()
{
	CActor *pOwner=m_pWeapon->GetOwnerActor();
	if (!pOwner)
		return;

	EntityId detonatorId = pOwner->GetInventory()->GetItemByClass("Detonator");
	
	if (!detonatorId)
		g_pGame->GetIGameFramework()->GetIItemSystem()->GiveItem(pOwner, "Detonator", true, false, false);
	
	pOwner->SelectItemByName("Detonator", false);
}