/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Throw Fire Mode Implementation

-------------------------------------------------------------------------
History:
- 26ye:10:2005   15:45 : Created by Mrcio Martins

*************************************************************************/
#ifndef __PLANT_H__
#define __PLANT_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "Single.h"


class CPlant : public CSingle
{
protected:
	typedef struct SPlantParams
	{
		SPlantParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(hide_ammo,			true);
			ResetValue(helper,				true);
			ResetValue(impulse,				10.0f);
			ResetValue(delay,					0.25f);
			ResetValue(timed,					true);
			ResetValue(tick,					5.0f);
			ResetValue(tick_time,			0.45f);
			ResetValue(min_time,			5.0f);
			ResetValue(max_time,			180.0f);
			ResetValue(led_minutes,		true);
			ResetValue(led_layers,		"d%d%d");
		};

		bool		hide_ammo;
		string	helper;
		float		impulse;
		float		delay;
		bool		timed;
		float		tick;
		float		tick_time;
		float		min_time;
		float		max_time;
		bool		led_minutes;
		string	led_layers;
	} SPlantParams;

	typedef struct SPlantActions
	{
		SPlantActions() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(press_button,	"press_button");
			ResetValue(hold_button,	"hold_button");
			ResetValue(release_button,	"release_button");
			ResetValue(tick,	"tick");
		};

		string press_button;
		string hold_button;
		string release_button;
		string tick;
	} SPlantActions;

public:
	CPlant();
	virtual ~CPlant();

	virtual void Update(float frameTime, uint frameId);

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual void Activate(bool activate);

	virtual bool CanReload() const;
	virtual bool IsReadyToFire() const;
	virtual void StartFire(EntityId shooterId);
	virtual void StopFire(EntityId shooterId);

protected:

	virtual float GetTime();
	virtual void CheckAmmo();
	virtual void DoTick();
	virtual void DoPlant();
	virtual void SetLED(float time, bool minutes, const char *layerFmt);
	virtual void StartPlant();
	virtual void SelectDetonator();

	float	m_plantTimer;

	SPlantParams	m_plantparams;
	SPlantActions	m_plantactions;

	bool	m_pressing;
	bool	m_holding;
	bool	m_startplant;
	float	m_time;
	float	m_tickTimer;
};

#endif 