/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Implements the player.
  
 -------------------------------------------------------------------------
  History:
  - 29:9:2004: Created by Filippo De Luca

*************************************************************************/
#ifndef __PLAYER_H__
#define __PLAYER_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "Actor.h"
#include "NanoSuit.h"
#include <IActionMapManager.h>
#include "Network/NetActionSync.h"

class CPlayerMovement;
class CPlayerRotation;
struct IPlayerInput;
class CHUD;

struct SPlayerStats : public SActorStats
{
	float onGroundWBoots;

	float inMovement;//for how long the player is moving
	float inRest;//for how long the player is standing still

	bool landed;
	bool jumped;

	bool inZeroG;

	float jumpLock;
	
	float inWater;
	float waterLevel;

	float flatSpeed;	// calced from the velocity returned by physics and baseMtx
	float mass;
	float	bobCycle;
	
	float leanAmount;
	
	float shakeAmount; 

	Vec3 physCamOffset;
	float heightPivot;

	// falling things
	float fallDistance;
	bool isFalling;
	Vec3 startFallPos;

	bool isFiring;

	bool isThirdPerson;
	
  bool isFrozen;
	bool isWalkingOnWater;
	bool isOnLadder;

	bool followCharacterHead;
	uint8 firstPersonBody;

	//useful for smoothing out the view
	uint8 viewID;
	uint8 viewIDLast;
	float smoothViewZ;
	uint8 smoothZType;

	bool animationControlled;

	//cheating stuff
	uint8 flyMode;//0 no fly, 1 fly mode, 2 fly mode + noclip
	uint8 godMode;//0 no god, 1 player is god, 2 player and squadmates are god
	//

	Vec3 velocity;
	Vec3 velocityUnconstrained;

	Vec3 upVector;
	Vec3 groundNormal;

	Vec3 gravity;

	Vec3 HUDPos;
	Ang3 HUDAngles;

	Vec3 FPWeaponPos;
	Ang3 FPWeaponAngles;

	Vec3 FPSecWeaponPos;
	Ang3 FPSecWeaponAngles;

	Vec3 gBootsSpotNormal;
	Vec3 gyroScopeNormal;

	char vehicleName[32];
	int vehicleSeat;

	//
	Ang3 angularVel;
	
	Ang3 angularImpulse;
	float angularImpulseDeceleration;
	float angularImpulseTime;
	float angularImpulseTimeMax;

	//
	float thrusterSprint;

	SPlayerStats()
	{
		memset(this,0,sizeof(SPlayerStats));
		new (this) SActorStats();

		inAir = 1.0f;

		firstPersonBody = 2;
				
		strcpy(vehicleName,"none");

		upVector.Set(0,0,1);

		thrusterSprint = 1.0f;
	}

	void Serialize( TSerialize ser, unsigned aspects );
};

struct SPlayerParams : public SActorParams
{
	float sprintMultiplier;
	float strafeMultiplier;
	float backwardMultiplier;
	float grabMultiplier;
	float afterburnerMultiplier;

	float inertia;
	float inertiaAccel;
		
	float jumpHeight;
		
	float leanShift;
	float leanAngle;

	float thrusterImpulse;
	float thrusterStabilizeImpulse;

	float gravityBootsMultipler;

	Vec3	hudOffset;
	Ang3	hudAngleOffset;

	//view limit stuff
	//FIXME: not sure if keep these here

	//ladder
	//FIXME: not sure if keep these here
	Vec3	ladderTop;
	Vec3	ladderBottom;

	//
	char animationAppendix[32];

	SPlayerParams()
	{
 		memset(this,0,sizeof(SPlayerParams));
		new (this) SActorParams();

		sprintMultiplier = 1.5f;
		strafeMultiplier = 0.9f;
		backwardMultiplier = 0.9f;
		grabMultiplier = 0.5f;
		afterburnerMultiplier = 1.5f;

		inertia = 7.0f;
		inertiaAccel = 11.0f;
		
		jumpHeight = 1.0f;
		
		leanShift = 0.5f;
		leanAngle = 11.0f;
		
		thrusterImpulse = 5.0f;
		thrusterStabilizeImpulse = 1.0f;

		gravityBootsMultipler = 0.7f;

		strcpy(animationAppendix,"nw");

		ladderTop.Set(0,0,0);
		ladderBottom.Set(0,0,0);
	}
};

class CPlayerView;

class CPlayer :
	public CActor
{
	friend class CPlayerMovement;
	friend class CPlayerRotation;
	friend class CPlayerInput;
	friend class CPlayerView;

public:

	CPlayer();
	virtual ~CPlayer();

	virtual void Draw(bool draw);
	virtual void BindInputs( IAnimationGraph * pGraph );
	virtual bool Init( IGameObject * pGameObject );
	virtual void PostInit( IGameObject * pGameObject );
	virtual void ProcessEvent(SEntityEvent& event);
	virtual void SetAuthority( bool auth );
	virtual void SerializeXML( XmlNodeRef& node, bool bLoading );
	virtual void Update(SEntityUpdateContext& ctx, int updateSlot);
	virtual void UpdateView(SViewParams &viewParams);

	virtual void LinkToVehicle(EntityId vehicleId);
	virtual void LinkToVehicleRemotely(EntityId vehicleId);

	Vec3 GetLastRequestedVelocity() const { return m_lastRequestedVelocity; }

protected:
	virtual IActorMovementController * CreateMovementController();
	virtual void SetIK( const SActorFrameMovementParams& );

public:
	//set/get actor status
	virtual void SetStats(SmartScriptTable &rTable);
	virtual bool GetStats(SmartScriptTable &rTable);
	virtual void UpdateStats(float frameTime);
	virtual void SetParams(SmartScriptTable &rTable,bool resetFirst);
	virtual bool GetParams(SmartScriptTable &rTable);

	// Accessed via function to allow game based modifiers to stance speed without multiplying the number of stances.
	virtual float GetStanceMaxSpeed(EStance stance) const;

	virtual void ToggleThirdPerson();

	virtual bool IsZeroG();
	virtual bool IsOnLadder();
	virtual int  IsGod(){ return m_stats.godMode; }
	virtual void Revive( bool fromInit );

	//stances
	virtual Vec3	GetStanceViewOffset(EStance stance,bool withLean = true,bool withY = false) const;
	virtual bool IsThirdPerson() const;
	virtual void StanceChanged(EStance last);

	// FIXME: Temp access for the HUD
	CNanoSuit &GetNanoSuit() { return m_nanoSuit; }
	const CNanoSuit &GetNanoSuit() const { return m_nanoSuit; }

	virtual void SelectNextItem(int direction, bool keepHistory);
	virtual void RagDollize();
	virtual void HandleEvent( const SGameObjectEvent& event );
	virtual void UpdateHUD();

	virtual void UpdateAnimGraph(IAnimationGraphState * pState);
	virtual void PostUpdate(float frameTime);
	virtual void SetViewAngleOffset(const Vec3 &offset) { m_viewAnglesOffset = offset; };
	virtual Vec3 GetViewAngleOffset() { return (Vec3)m_viewAnglesOffset; };

	virtual void Serialize( TSerialize ser, unsigned aspects );
	//set/get actor params
	virtual void SetHealth(int health );
	virtual SActorStats *GetActorStats() { return &m_stats; };
	virtual SActorParams *GetActorParams() { return &m_params; };
	virtual void PostPhysicalize();
	virtual void CameraShake(float angle,float shift,float duration,float frequency,Vec3 pos,int ID);
	virtual void CreateCodeEvent(SmartScriptTable &rTable);
	virtual void VectorToLocal(Vec3 &v);
	virtual void AddAngularImpulse(const Ang3 &angular,float deceleration, float duration);
	virtual void SetAngles(const Ang3 &angles);
	virtual Ang3 GetAngles();
	virtual void PlayAction(const char *action,const char *extension);
	virtual void UpdateGrab(float frameTime);
	virtual float GetActorStrength() const;
	virtual void Freeze(bool frozen, float mass, const char *material);
	virtual void ProcessBonesRotation(ICharacterInstance *pCharacter,float frameTime);
	virtual void ProcessIKLegs(ICharacterInstance *pCharacter,float frameTime);
	virtual IVehicle *GetLinkedVehicle() const;
	virtual IEntity *GetLinkedEntity() const;
	const Matrix33& GetBaseMatrix() { return m_baseMtx; }
	const Matrix33& GetViewMatrixFinal() { return m_viewMtxFinal; }
	virtual void ResetAnimations();
	virtual CHUD * GetHUD();
	float GetMassFactor() const;
  float GetFrozenAmount() const; 
	const std::auto_ptr<IPlayerInput>* GetPlayerInput() const {return &m_pPlayerInput;}

private:
	void AnimationControlled(bool activate);

protected:
	Vec3		m_modelOffset;
	float		m_groundElevation;
	Ang3 		m_viewAnglesOffset;//used for recoil
	Ang3		m_headAngles;//head angles in local space, for bones rotation

	virtual bool IsMaterialBootable(int matId) const;

	CNanoSuit m_nanoSuit;

	Ang3		m_angleOffset;	// Used only by the view system. (retained state)
	Matrix33	m_viewMtx;//view matrix
	Matrix33	m_viewMtxFinal;//the final exact view matrix (with recoil added)
	Matrix33	m_baseMtx;//base rotation matrix, rotating on the Z axis

	Vec3		m_eyeOffset;	// View system - used to interpolate to goal eye offset
												//the offset from the entity origin to eyes, its not the real offset vector but its referenced to player view direction.

	float		m_viewRoll;

	Vec3		m_upVector;//using gravity boots (or when prone) is the normal of the surface where the player is standing on, otherwise is the default (0,0,1)

	Vec3		m_bobOffset;
	
	Vec3		m_FPWeaponLastDirVec;
	Vec3		m_FPWeaponOffset;
	Ang3		m_FPWeaponAngleOffset;

	// updated by PlayerMovement for tracking time based acceleration
	Vec3		m_velocity;
	// updated by PlayerMovement to allow for turning faster than we can in one frame
	Quat    m_turnTarget;
	Vec3		m_lastRequestedVelocity;

	SPlayerStats		m_stats;
	SPlayerParams		m_params;

	//first person body
	Vec3 m_blendViewOffset;			// View system - Used when blending between views
	Quat m_blendViewRotOffset;	// View system - Used when blending between views

	std::auto_ptr<IPlayerInput> m_pPlayerInput;

	// for foot/leg ik
	Vec3 m_feetWpos[2];

	// compatibility with old code: which actions are set
	int m_actions;

	// TODO: wish i could figure out a way of removing this
	// was the rotation forced this frame?
	bool m_forcedRotation;

	// animation graph input ids
	IAnimationGraph::InputID m_inputItem;
	IAnimationGraph::InputID m_inputVehicleName;
	IAnimationGraph::InputID m_inputVehicleSeat;
	IAnimationGraph::InputID m_inputUsingLookIK;

	// which vehicle are we in?
	EntityId m_vehicleId;

  // probably temporary, feel free to figure out better place
  float m_lastAnimControlled;
  Quat m_lastAnimContRot;
  Vec3 m_lastAnimContPos;

	// Called from CPlayer::Update if actor is alive and not a rag doll. Hook for inheritance.
	virtual void UpdateAsLiveAndMobile(SEntityUpdateContext & ctx) {;}
	// Called from CPlayer::Update if actor is dead or a rag doll. Hook for inheritance.
	virtual void UpdateAsDoll(SEntityUpdateContext & ctx) {;}
	// Called from CPlayer::Update. Hook for inheritance.
	virtual IPlayerInput * CreatePlayerInput();
};


#endif //__PLAYER_H__
