
#include "StdAfx.h"
#include "PlayerActionMap.h"
#include "G4PlayerInput.h"

// Player action map is a singleton.
CPlayerActionMap *CPlayerActionMap::GetPlayerActionMap()
{
	// Keeping this as a static local guarantees that pMap is constructed to 0 before
	// this code runs, even if called from the constructor of a static class.
	static CPlayerActionMap *pMap=0;
	if(!pMap)
		pMap=new CPlayerActionMap();
	return pMap;
}

void CPlayerActionMap::Clear()
{
	{
		TPlayerActionMap dummy;
		TPlayerActionMapIter itMap,itEnd;

		for(itMap = m_playerActionMap.begin(), itEnd=m_playerActionMap.end() ; itMap != itEnd ; ++itMap)
		{
			delete(itMap->second->pStrName);
			delete(itMap->second);
		}

		m_playerActionMap.swap(dummy);  // Use stl swap trick to make sure memory is free'd
	}
	{
		TPlayerActionStateMap dummy;
		TPlayerActionStateIter itMap,itEnd;

		for(itMap = m_playerActionState.begin(), itEnd=m_playerActionState.end() ; itMap != itEnd ; ++itMap)
		{
			delete(itMap->second->pStrName);
			delete(itMap->second);
		}

		m_playerActionState.swap(dummy);  // Use stl swap trick to make sure memory is free'd
	}
}

CPlayerActionMap::~CPlayerActionMap()
{
	Clear();
}

// Algorithm extracted from LUA lstring.c:luaS_newlstr
unsigned int CPlayerActionMap::CalcHash(const char *psActionName)
{
	unsigned int lenStr = strlen(psActionName);
	unsigned int hash = lenStr;  // seed
	unsigned int step = (lenStr>>5)+1;  // if string is too long, don't hash all its chars
	unsigned int iStr;

	for (iStr=lenStr; iStr>=step; iStr-=step)  /* compute hash */
		hash = hash ^ ((hash<<5)+(hash>>2)+(unsigned char)(psActionName[iStr-1]));

	return hash;
}

bool CPlayerActionMap::OnAction(CPlayerInputG4 *pPlayerInput,const char *actionName, int activationMode, float value)
{
	bool bRet=true;
	TPlayerActionMap_OnAction fnHandler;

	unsigned int hashId=CalcHash(actionName);

	//-- Update the frame action state only for the player at present.
	if(pPlayerInput->IsClient())
	{
		SPlayerActionState *pS=GetActionState(hashId,actionName);
		pS->bThisFrame=true;
		pS->value=value;
	}

	//-- If there's a handler then call it
	if(GetHandler(hashId,actionName,fnHandler))
	{
		// do a this-call to the non-static member function pointed to by fnHandler
		// ( ie the pointer to function version of pPlayer->MyHandler() )
		bRet=(pPlayerInput->*fnHandler)(actionName,activationMode,value);
	}

	return bRet;
}

void CPlayerActionMap::AddHandler(const char *psActionName,TPlayerActionMap_OnAction fnHandler)
{
	if(psActionName)
	{
		SPlayerActionBinding *pBind=new SPlayerActionBinding();
		pBind->pStrName=new string(psActionName);
		pBind->fnHandler=fnHandler;

		unsigned int hashId = CalcHash(psActionName);

		m_playerActionMap.insert( std::make_pair(hashId,pBind) );
	}
}

bool CPlayerActionMap::GetHandler(unsigned int hashAction,const char *actionName,TPlayerActionMap_OnAction &rFnHandler)
{
	bool bRet=false;
	TPlayerActionMapIter itMap,itEnd;
	unsigned int hashId=hashAction;//CalcHash(actionName);

	for(itMap = m_playerActionMap.find(hashId), itEnd=m_playerActionMap.end(); itMap != itEnd && itMap->first == hashId; ++itMap)
	{
		if(0==strcmp(itMap->second->pStrName->c_str(),actionName))
		{
			rFnHandler=itMap->second->fnHandler;
			bRet=true;
			break;
		}
	}

	return bRet;
}

SPlayerActionState *CPlayerActionMap::GetActionState(unsigned int hashAction,const char *psActionName)
{
	SPlayerActionState *pRet=0;
	TPlayerActionStateIter itMap,itEnd;
	unsigned int hashId=hashAction;//CalcHash(actionName);

	for(itMap = m_playerActionState.find(hashId), itEnd=m_playerActionState.end(); itMap != itEnd && itMap->first == hashId; ++itMap)
	{
		if(0==strcmp(itMap->second->pStrName->c_str(),psActionName))
		{
			pRet=itMap->second;
			break;
		}
	}

	if(!pRet)
	{
		pRet=new SPlayerActionState();
		pRet->pStrName=new string(psActionName);
		pRet->bThisFrame=false;
		pRet->value=0;
		m_playerActionState.insert( std::make_pair(hashId,pRet) );
	}

	return pRet;
}

// Clear the actions ready for a new frame
void CPlayerActionMap::ClearActionStates()
{
	TPlayerActionStateIter itMap,itEnd;
	for(itMap = m_playerActionState.begin(), itEnd=m_playerActionState.end(); itMap != itEnd ; ++itMap)
	{
		itMap->second->bThisFrame=false;
	}
}


