/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Binds and Dispatches OnAction messages to handlers
-------------------------------------------------------------------------
History:
- 06:03:2005: Created by Nick Hesketh ( Refactored from G4Player.h )

*************************************************************************/

#ifndef __PLAYERACTIONMAP_H__
#define __PLAYERACTIONMAP_H__

#if _MSC_VER > 1000
# pragma once
#endif


//--------------------------------------------------
//--- CPlayerActionMap
//--------------------------------------------------
// 
//--------------------------------------------------


#include <map>

class CPlayerInputG4;
// Returns true if the action should also be forwarded to scripts
typedef bool (CPlayerInputG4::*TPlayerActionMap_OnAction)(const char *actionName, int activationMode, float value);

struct SPlayerActionBinding
{
	string *pStrName;
	TPlayerActionMap_OnAction fnHandler;
};

struct SPlayerActionState
{
	string *pStrName;
	bool bThisFrame;
	float value;
};

typedef std::multimap<unsigned int, SPlayerActionBinding*> TPlayerActionMap;
typedef std::multimap<unsigned int, SPlayerActionBinding*>::iterator TPlayerActionMapIter;
typedef std::multimap<unsigned int, SPlayerActionState*> TPlayerActionStateMap;
typedef std::multimap<unsigned int, SPlayerActionState*>::iterator TPlayerActionStateIter;


class CPlayerActionMap
{
public:

	void AddHandler(const char *psActionName,TPlayerActionMap_OnAction fnHandler);

	bool OnAction(CPlayerInputG4 *pPlayer,const char *actionName, int activationMode, float value);

	~CPlayerActionMap();

	static CPlayerActionMap *GetPlayerActionMap();

	void Clear();

	//
	SPlayerActionState *GetActionState(const char *psActionName)
	{ return GetActionState(CalcHash(psActionName),psActionName); }

	// Clear the actions ready for a new frame
	void ClearActionStates();
protected:
	TPlayerActionMap m_playerActionMap;
	TPlayerActionStateMap m_playerActionState;

	CPlayerActionMap() {;}

	unsigned int CalcHash(const char *psActionName);

	bool GetHandler(unsigned int hashAction,const char *psActionName,TPlayerActionMap_OnAction &rFnHandler);

	bool GetHandler(const char *psActionName,TPlayerActionMap_OnAction &rFnHandler)
	{
		unsigned int hashId=CalcHash(psActionName);
		return GetHandler(hashId,psActionName,rFnHandler);
	}

	SPlayerActionState *GetActionState(unsigned int hashAction,const char *psActionName);

};


#endif // ifndef __PLAYERACTIONMAP_H__
