// handles turning actions into CMovementRequests and setting player state
// for the local player

#ifndef __PLAYERINPUT_H__
#define __PLAYERINPUT_H__

#pragma once

#include "IActionMapManager.h"
#include "IPlayerInput.h"

class CPlayer;
struct SPlayerStats;

class CPlayerInput : public IPlayerInput, public IActionListener
{
public:
	CPlayerInput( CPlayer * pPlayer );
	~CPlayerInput();

	// IActionListener
	virtual void OnAction( const ActionId& action, int activationMode, float value );
	// ~IActionListener
	
	// IPlayerInput
	virtual void PreUpdate();
	virtual void Update();
	virtual void PostUpdate();

	virtual void SetState( const SSerializedPlayerInput& input );
	virtual void GetState( SSerializedPlayerInput& input );

	virtual void Reset();
	// ~IPlayerInput

private:

	EStance FigureOutStance();
	void AdjustMoveKeysPressed( int activationMode );

	void ApplyMovement(Vec3 delta);
	const Vec3 &FilterMovement(const Vec3 &desired);

private:

	CPlayer * m_pPlayer;
	SPlayerStats * m_pStats;

	uint32 m_actions;
	Vec3 m_deltaMovement;
	Ang3 m_deltaRotation;
	Ang3 m_xi_deltaRotation;
	int m_moveKeysPressed;

	Vec3 m_filteredDeltaMovement;
};

#endif
