// takes input rotations and movement requests, and produces physical impulses/turns based upon current player state

#ifndef __PLAYERMOVEMENT_H__
#define __PLAYERMOVEMENT_H__

#pragma once

#include "Player.h"

class CPlayerMovement
{
public:
	CPlayerMovement( const CPlayer& player, const SActorFrameMovementParams& movement, float frameTime );
	void Process();
	void Commit( CPlayer& player );

private:
	const float m_frameTime;
	const SPlayerParams& m_params;
	const SPlayerStats& m_stats;
	SActorFrameMovementParams m_movement;
	const CPlayer& m_player;
	const Matrix33& m_viewMtx;
	const Matrix33& m_baseMtx;
	const Vec3& m_upVector;
	Vec3 m_worldPos;
	const int m_actions;

	void ProcessFlyMode();
	void ProcessLadder();
	void ProcessFlyingZeroG();
	void ProcessSwimming();
	void ProcessOnGroundOrJumping();
	void ProcessTurning();

	void AdjustMovementForEnvironment( Vec3& movement );

	SCharacterMoveRequest m_request; // our primary output... how to move!
	bool m_detachLadder; // do we want to detach from a ladder?
	Vec3 m_velocity; // from CPlayer... gets updated here and committed
	float m_onGroundWBoots;
	bool m_jumped;
	Vec3 m_gBootsSpotNormal;
	float m_thrusters;
	Quat m_turnTarget;
	float m_thrusterSprint;

};


#endif
