#ifndef __PLAYERMOVEMENTCONTROLLER_H__
#define __PLAYERMOVEMENTCONTROLLER_H__

#pragma once

#include "Player.h"
#include "TimeValue.h"
#include "GameUtils.h"

class CPlayerMovementController : public IActorMovementController
{
public:
	CPlayerMovementController( CPlayer * pPlayer );
	inline virtual ~CPlayerMovementController() {}

	virtual void Reset();
	virtual bool Update( float frameTime, SActorFrameMovementParams& params );
	virtual void Release();

	virtual bool RequestMovement( CMovementRequest& request );
	virtual void GetMovementState( SMovementState& state )
	{
		state = m_currentMovementState;
		if (m_pPlayer->IsPlayer())
			state.aimDirection = m_pPlayer->GetViewMatrixFinal().GetColumn(1);
	};

protected:
	CPlayer * m_pPlayer;

	typedef bool (CPlayerMovementController::*UpdateFunc)( float frameTime, SActorFrameMovementParams& params );
	UpdateFunc m_updateFunc;

	bool UpdateNormal( float frameTime, SActorFrameMovementParams& params );

	CMovementRequest m_state;
	float m_desiredSpeed;
	bool m_atTarget;
	bool m_usingLookIK;
	bool m_usingAimIK;

	SMovementState m_currentMovementState;
	virtual void UpdateMovementState( SMovementState& state );

	class CTargetInterpolator
	{
	public:
		CTargetInterpolator() { Reset(); }
		void Reset() { m_lastValue = 0.0f; }

		bool HasTarget( CTimeValue now, CTimeValue timeout ) const 
		{ 
			return m_lastValue > 0.0f && now - m_lastValue < timeout; 
		}
		Vec3 GetTarget() const { return m_target; }

		void GetTarget( Vec3& target, Vec3& rotateTarget, const Vec3& playerPos, const Vec3& moveDirection, float maxAngle, ColorB * clr = NULL ) const
		{
			target = GetTarget();
			Vec3 direction = (target - playerPos).GetNormalizedSafe();

			if (clr)
			{
				GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine( playerPos, *clr, target, *clr );
				GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere( playerPos + direction, 0.3f, *clr );
				GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere( target, 0.4f, *clr );
			}

			if (direction.Dot(moveDirection) < cry_cosf(maxAngle))
			{
				rotateTarget = target;
				Vec3 normal = moveDirection.Cross(direction).GetNormalizedSafe(Vec3(0,0,1));
				Vec3 target1 = moveDirection.GetRotated( normal, maxAngle );
				Lineseg line1( moveDirection, direction );
				Lineseg line2( ZERO, target1 );
				float t1, t2;
				Intersect::Lineseg_Lineseg2D( line1, line2, t1, t2 );
				target = line1.GetPoint(t1)*((target-playerPos).len()+0.8f) + playerPos;
				if (clr)
				{
					GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine( playerPos + moveDirection, ColorB(255,255,255,255), playerPos + target1, *clr );
					GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine( playerPos, ColorB(255,255,255,255), playerPos + target1, *clr );
					GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere( target, 0.2f, *clr );
				}
				assert( (target-playerPos).GetNormalized().Dot(moveDirection) >= (cry_cosf(maxAngle) - 0.1f) );
			}
		}

		void TargetValue( const Vec3& value, CTimeValue now, CTimeValue timeout, float frameTime, bool updateLastValue, const Vec3& playerPos, float maxAngularVelocity )
		{
			if (HasTarget(now, timeout))
			{
				Vec3 curPos = m_target - playerPos;
				Vec3 newPos = value - playerPos;
				float cosThresh = cry_cosf(maxAngularVelocity * frameTime);
				if (curPos.Dot(newPos)/curPos.len()/newPos.len() < cosThresh)
				{
					Vec3 normal = curPos.Cross(newPos).GetNormalizedSafe(Vec3(0,0,1));
          Vec3 newPos1 = curPos.GetRotated( normal, maxAngularVelocity*frameTime );
					Lineseg line1( curPos, newPos );
					Lineseg line2( ZERO, newPos1 );
					float t1, t2;
					Intersect::Lineseg_Lineseg2D( line1, line2, t1, t2 );
					newPos = line1.GetPoint(t1);
				}
				m_target = newPos + playerPos;
				//Interpolate( m_target, value, 12.0f, frameTime );
			}
			else
				m_target = value;

m_target = value;

			if (updateLastValue)
				m_lastValue = now;
		}

	private:
		CTimeValue m_lastValue;
		Vec3 m_target;
	};
	CTargetInterpolator m_aimInterpolator;
	CTargetInterpolator m_lookInterpolator;
};

#endif
