// takes input rotations and movement requests, and produces physical impulses/turns based upon current player state

#ifndef __PLAYERROTATION_H__
#define __PLAYERROTATION_H__

#pragma once

#include "Player.h"

class CPlayerRotation
{
public:
	CPlayerRotation( const CPlayer& player, const SActorFrameMovementParams& movement, float frameTime );
	void Process();
	void Commit( CPlayer& player );

private:
	const float m_frameTime;
	const SPlayerParams& m_params;
	const SPlayerStats& m_stats;
	const CPlayer& m_player;
	const int m_actions;

	Ang3 m_deltaAngles;
	float m_desiredLean;

	void GetStanceAngleLimits(float & minAngle,float & maxAngle);
	ILINE float GetLocalPitch()
	{
		return asin((m_baseMtx.GetInverted() * m_viewMtx.GetColumn(1)).z);
	}

	void ProcessFreezeShaking();
  void CommitFreezeShaking( CPlayer& player );
	void ProcessFlyingZeroG();

	void ProcessNormalRoll();
	void ProcessAngularImpulses();
	void ClampAngles();
	void ProcessNormal();
	void ProcessLean();
  

	Matrix33 m_viewMtx;
	Matrix33 m_viewMtxFinal;
	Matrix33 m_baseMtx;
	float m_viewRoll;
	Vec3 m_upVector;
	Vec3 m_viewAnglesOffset;
	float m_leanAmount;	
  float m_freezeDelta;
	float m_absRoll;

	// angular impulses - from stats
	float m_angularImpulseTime;
	Ang3 m_angularImpulse;
	Ang3 m_angularVel;
	// internal working vars
	Ang3 m_angularImpulseDelta;
};

/*
CPlayerRotation movementProcessing(*this);
movementProcessing.Process();
movementProcessing.Commit(*this);
*/

#endif
