/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

Description:
	The view specific code (First person, Third person, followCharacterHead etc).


-------------------------------------------------------------------------
History:
- 21:02:2006: Re-factored from Filippo's CPlayer code by Nick Hesketh

*************************************************************************/

#include "StdAfx.h"

#include "Game.h"
#include "Player.h"
#include "PlayerView.h"
#include "GameUtils.h"
#include "GameActions.h"

#include "Weapon.h"
#include "WeaponSystem.h"

#include <IViewSystem.h>
#include <IItemSystem.h>
#include <IPhysics.h>
#include <ICryAnimation.h>
#include "IAISystem.h"
#include "IAgent.h"
#include <IVehicleSystem.h>
#include <ISerialize.h>

#include <IRenderAuxGeom.h>

#include <IGameTokens.h>

#include "HUD/HUD.h"


//CPlayerView::SViewStateIn CPlayerView::m_in;
//CPlayerView::SViewStateInOut CPlayerView::m_io;

CPlayerView::CPlayerView(const CPlayer &rPlayer,SViewParams &viewParams) : m_in(m_viewStateIn_private)
{
	//ViewPreProcess(rPlayer,viewParams,m_viewStateIn_private);
}

void CPlayerView::Process(SViewParams &viewParams)
{
	//ViewProcess(viewParams);
}

void CPlayerView::Commit(CPlayer &rPlayer,SViewParams &viewParams)
{
	//ViewPostProcess(rPlayer,viewParams);
}

//-----------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------
//--- ViewPreProcess
//--------------------------------------------------------------------------
// Fetch all the data we need to work on.
//--------------------------------------------------------------------------
void CPlayerView::ViewPreProcess(const CPlayer &rPlayer,SViewParams &viewParams,SViewStateIn &m_in)
{

	// SViewStateIn --- the constants
	{
		m_in.lastPos=viewParams.position;
		m_in.lastQuat=viewParams.rotation;
		m_in.defaultFov= g_pGame->GetCVars()->cl_fov->GetFVal();
		
		m_in.frameTime=min(GetISystem()->GetITimer()->GetFrameTime(),0.1f);
		
		m_in.pCharacter = rPlayer.GetEntity()->GetCharacter(0);
		m_in.pVehicle=rPlayer.GetLinkedVehicle();
		
		m_in.bIsGrabbing=false;
		if (rPlayer.m_grabStats.grabId>0)
		{
			m_in.bIsGrabbing=true;
			// *****
			viewParams.nearplane = 0.1f;
			// *****
		}
		
		m_in.stats_isRagDoll=rPlayer.m_stats.isRagDoll;
		m_in.stats_followCharacterHead=rPlayer.m_stats.followCharacterHead;
		m_in.stats_flatSpeed=rPlayer.m_stats.flatSpeed;	
		m_in.stats_leanAmount=rPlayer.m_stats.leanAmount;
		m_in.stats_inAir=rPlayer.m_stats.inAir;	
		m_io.stats_jumped=rPlayer.m_stats.jumped;
		m_in.stats_firstPersonBody=rPlayer.m_stats.firstPersonBody;	
		m_in.stats_onGround=rPlayer.m_stats.onGround;
		m_io.stats_landed=rPlayer.m_stats.landed;
		m_in.stats_velocity=rPlayer.m_stats.velocity;
	
		m_in.params_viewFoVScale=rPlayer.m_params.viewFoVScale;
		m_in.params_viewPivot=rPlayer.m_params.viewPivot;
		m_in.params_headBobbingMultiplier=rPlayer.m_params.headBobbingMultiplier;
		m_in.params_viewDistance=rPlayer.m_params.viewDistance;
		m_in.params_weaponInertiaMultiplier=rPlayer.m_params.weaponInertiaMultiplier;
		m_in.params_hudAngleOffset=rPlayer.m_params.hudAngleOffset;
		m_in.params_hudOffset=rPlayer.m_params.hudOffset;	
		m_in.params_viewHeightOffset=rPlayer.m_params.viewHeightOffset;
		m_in.params_weaponBobbingMultiplier=rPlayer.m_params.weaponBobbingMultiplier;
		
		m_in.cl_bob=g_pGame->GetCVars()->cl_bob->GetFVal();
		
		m_in.bIsThirdPerson=rPlayer.IsThirdPerson();
		m_in.vEntityWorldPos=rPlayer.GetEntity()->GetWorldPos();
		m_in.entityId=rPlayer.GetEntityId();	
		m_in.entityWorldMatrix=Matrix34(rPlayer.GetEntity()->GetSlotWorldTM(0));	
		m_in.localEyePos=rPlayer.GetLocalEyePos();
		m_in.worldEyePos=m_in.entityWorldMatrix*m_in.localEyePos;
		
		{
			int16 joint_id = rPlayer.GetBoneID(BONE_HEAD);
	
			if (joint_id>=0)
			{
				m_in.headMtxLocal=Matrix33(m_in.pCharacter->GetISkeleton()->GetAbsJMatrixByID(joint_id));
				viewParams.rotation = Quat(rPlayer.GetEntity()->GetSlotWorldTM(0) * m_in.headMtxLocal * Matrix33::CreateRotationY(gf_PI*0.5f));
			}
			else
			{
				m_in.headMtxLocal=Matrix33::CreateIdentity();
			}
		}
	
		//FIXME:dont hook up the cvar each frame, just store the Cvar *
		m_in.thirdPersonDistance=g_pGame->GetCVars()->cl_tpvDist->GetFVal();
		m_in.thirdPersonYaw=g_pGame->GetCVars()->cl_tpvYaw->GetFVal();
		
		m_in.stand_MaxSpeed=rPlayer.GetStanceInfo(STANCE_STAND)->maxSpeed;
	
		m_in.health=rPlayer.GetHealth();
		m_in.stance=rPlayer.m_stance;
		m_in.shake= g_pGame->GetCVars()->cl_sprintShake->GetFVal();
		m_in.standSpeed=rPlayer.GetStanceMaxSpeed(STANCE_STAND);	
	}
	
	// SViewStateInOut -- temporaries and output
	{
		//--- temporaries - FirstThird shared
		
		//m_io.bUsePivot
		//m_io.bobMul
		//m_io.viewMtxForWeapon
		//m_io.eyeOffsetGoal
		
		//--- temporaries - view shared
		m_io.wAngles=Ang3(0,0,0);
		//--- I/O
		//m_io.m_lastPos=rPlayer.m_lastPos;
		// Integ
		//if (m_io.m_lastPos.len2()>0.01f)
		//{
		//	m_io.blendViewOffset = m_io.m_lastPos - rPlayer.GetEntity()->GetWorldPos(); 
		//	m_io.m_lastPos.Set(0,0,0);
		//}
	}
	
	// *****
	viewParams.fov = m_in.defaultFov*rPlayer.m_params.viewFoVScale*(gf_PI/180.0f);
	viewParams.nearplane = 0.0f;
	// *****
		
	m_io.stats_HUDPos=rPlayer.m_stats.HUDPos;

	m_io.eyeOffsetGoal=rPlayer.GetStanceViewOffset(rPlayer.m_stance);

	m_io.viewMtxFinal=rPlayer.m_viewMtxFinal;
	m_io.viewMtx=rPlayer.m_viewMtx;

	m_io.stats_FPWeaponAngles=rPlayer.m_stats.FPWeaponAngles;
	m_io.stats_FPWeaponPos=rPlayer.m_stats.FPWeaponPos;

	m_io.vFPWeaponOffset=rPlayer.m_FPWeaponOffset;

	m_io.stats_FPSecWeaponAngles=rPlayer.m_stats.FPSecWeaponAngles;
	m_io.stats_FPSecWeaponPos=rPlayer.m_stats.FPSecWeaponPos;

	//m_io.viewShake=rPlayer.m_viewShake;

	m_io.eyeOffset=rPlayer.m_eyeOffset;
	m_io.baseMtx=rPlayer.m_baseMtx;

	m_io.vFPWeaponAngleOffset=rPlayer.m_FPWeaponAngleOffset;
	m_io.stats_bobCycle=rPlayer.m_stats.bobCycle;

	m_io.vFPWeaponLastDirVec=rPlayer.m_FPWeaponLastDirVec;
	m_io.bobOffset=rPlayer.m_bobOffset;
	m_io.angleOffset=rPlayer.m_angleOffset;
	m_io.viewAngleOffset = rPlayer.m_viewAnglesOffset;

	m_in.stats_flyMode=rPlayer.m_stats.flyMode;

	m_io.stats_smoothViewZ=rPlayer.m_stats.smoothViewZ;
	m_io.stats_smoothZType=rPlayer.m_stats.smoothZType;

	//-- Any individual PreProcess handlers should be called here
}

//--------------------------------------------------------------------------
//--- ViewProcess
//--------------------------------------------------------------------------
// Process our local copy of the data.
// (This is where all the actual work should occur)
//--------------------------------------------------------------------------
void CPlayerView::ViewProcess(SViewParams &viewParams)
{
	FUNCTION_PROFILER(GetISystem(), PROFILE_GAME);

	// Externally controlled first person view e.g. by animation
	if (m_in.stats_isRagDoll && !m_in.bIsThirdPerson && m_in.pCharacter && (m_in.stats_firstPersonBody==1 || m_in.stats_followCharacterHead))
	{
		ViewFollowCharacterFirstPerson(viewParams);
	}
	else if (m_in.pVehicle)
	{
		ViewVehicle(viewParams);
	}
	else
	{
		ViewFirstThirdSharedPre(viewParams);

		if (m_in.bIsThirdPerson || m_io.bUsePivot)
			ViewThirdPerson(viewParams);
		else
			ViewFirstPerson(viewParams);

		ViewFirstThirdSharedPost(viewParams);
	}
}

//--------------------------------------------------------------------------
//--- ViewPostProcess
//--------------------------------------------------------------------------
// Commit all the changes
//--------------------------------------------------------------------------
void CPlayerView::ViewPostProcess(CPlayer &rPlayer,SViewParams &viewParams)
{
	// update the player rotation if view control is taken from somewhere else (e.g. animation or vehicle)
	ViewExternalControlPostProcess(rPlayer,viewParams);

	//set first person weapon position/rotation
	FirstPersonWeaponPostProcess(rPlayer,viewParams);

	ViewShakePostProcess(rPlayer,viewParams);


	//--------------------------
	// Output changed temporaries - debugging.
	//--------------------------

	//--------------------------
	// Output changed state.
	//--------------------------
	//rPlayer.m_lastPos=m_io.m_lastPos;
	rPlayer.m_stats.HUDPos=m_io.stats_HUDPos;
	rPlayer.m_viewMtxFinal=m_io.viewMtxFinal;
	rPlayer.m_viewMtx=m_io.viewMtx;
	//FIXME:updating the baseMatrix due being in a vehicle or having a first person animations playing has to be moved somewhere else
	rPlayer.m_baseMtx=m_io.baseMtx;

	rPlayer.m_stats.FPWeaponAngles=m_io.stats_FPWeaponAngles;
	rPlayer.m_stats.FPWeaponPos=m_io.stats_FPWeaponPos;
	rPlayer.m_stats.FPSecWeaponAngles=m_io.stats_FPSecWeaponAngles;
	rPlayer.m_stats.FPSecWeaponPos=m_io.stats_FPSecWeaponPos;
	//rPlayer.m_viewShake=m_io.viewShake;

	rPlayer.m_eyeOffset=m_io.eyeOffset;
	rPlayer.m_stats.bobCycle=m_io.stats_bobCycle;

	rPlayer.m_FPWeaponAngleOffset=m_io.vFPWeaponAngleOffset;
	rPlayer.m_FPWeaponLastDirVec=m_io.vFPWeaponLastDirVec;
	rPlayer.m_FPWeaponOffset=m_io.vFPWeaponOffset;
	rPlayer.m_bobOffset=m_io.bobOffset;
	rPlayer.m_angleOffset=m_io.angleOffset;
	rPlayer.m_viewAnglesOffset = m_io.viewAngleOffset;
	rPlayer.m_stats.landed=m_io.stats_landed;
	rPlayer.m_stats.jumped=m_io.stats_jumped;
	//--------------------------

	HudPostProcess(rPlayer,viewParams);

	rPlayer.m_stats.shakeAmount = viewParams.shakingRatio;

	HandsPostProcess(rPlayer,viewParams);
}


void CPlayerView::ViewFirstThirdSharedPre(SViewParams &viewParams)
{
	viewParams.viewID = 0;

	m_io.bUsePivot = (m_in.params_viewPivot.len2() > 0) && !m_in.bIsThirdPerson;
	m_io.bobMul=m_in.cl_bob * m_in.params_headBobbingMultiplier;

	viewParams.position = m_io.bUsePivot ? m_in.params_viewPivot : m_in.vEntityWorldPos;

	m_io.viewMtxForWeapon=m_io.viewMtxFinal;

	m_io.viewMtxFinal *= Matrix33::CreateRotationXYZ(m_io.angleOffset * max(0.25f,m_io.bobMul) * gf_PI/180.0f);

	viewParams.rotation = GetQuatFromMat33(m_io.viewMtxFinal);

	//Vec3 eyeOffsetGoal(GetStanceViewOffset(m_stance));
}

void CPlayerView::ViewFirstThirdSharedPost(SViewParams &viewParams)
{
	//--- Update the eye offset and apply 
	{
		// Blend towards the goal eye offset
		Interpolate(m_io.eyeOffset,m_io.eyeOffsetGoal,10.0f,m_in.frameTime);

		//apply eye offset
		if (!m_io.bUsePivot)
		{
			//m_eyeOffset represent the shift on the side/forward/up (x,y,z)
			viewParams.position += m_io.baseMtx * m_io.eyeOffset;//m_baseMtx.GetColumn(0) * m_eyeOffset.x + m_baseMtx.GetColumn(1) * m_eyeOffset.y + m_baseMtx.GetColumn(2) * m_eyeOffset.z;

			if (m_in.stats_firstPersonBody==2)
			{
				float lookDown(m_io.viewMtxFinal.GetColumn(1) * m_io.baseMtx.GetColumn(2));
				float forwardOffset(0.0f);
				if (m_in.stance == STANCE_STAND)
					forwardOffset = 0.15f;

				viewParams.position += m_io.viewMtxFinal.GetColumn(1) * max(-lookDown,0.0f) * forwardOffset + m_io.viewMtxFinal.GetColumn(2) * max(-lookDown,0.0f) * 0.0f;
			}
		}
	}

	//--- Weapon orientation
	//FIXME: this should be done in the player update anyway.
	//And all the view position update. (because the game may need to know other players eyepos and such)
	//update first person weapon model position/angles
	{
		Quat wQuat(m_io.viewMtxForWeapon * Matrix33::CreateRotationXYZ(m_io.vFPWeaponAngleOffset * gf_PI/180.0f));
		//wQuat *= Quat::CreateSlerp(viewParams.shakeQuat,IDENTITY,0.5f);
		wQuat *= Quat::CreateSlerp(viewParams.currentShakeQuat,IDENTITY,0.5f);
		wQuat.Normalize();

		m_io.wAngles = Ang3(wQuat);
	}

	//smooth out the view elevation		
	if (m_in.stats_inAir < 0.1f && !m_in.stats_flyMode && !m_io.bUsePivot)
	{
		if (m_io.stats_smoothZType!=1)
		{
			m_io.stats_smoothViewZ = viewParams.position.z;
			m_io.stats_smoothZType = 1;
		}

		Interpolate(m_io.stats_smoothViewZ,viewParams.position.z,9.9f,m_in.frameTime);
		viewParams.position.z = m_io.stats_smoothViewZ;
	}
	else
	{
		if (m_io.stats_smoothZType==1)
		{
			m_io.stats_smoothViewZ = m_in.lastPos.z - m_io.stats_smoothViewZ;
			m_io.stats_smoothZType = 2;
		}

		Interpolate(m_io.stats_smoothViewZ,0.0f,9.9f,m_in.frameTime);
		viewParams.position.z += m_io.stats_smoothViewZ;
	}
}

void CPlayerView::ViewThirdPerson(SViewParams &viewParams)
{
	if (m_in.thirdPersonYaw>0.001f)
	{
		viewParams.rotation *= Quat::CreateRotationXYZ(Ang3(0,0,m_in.thirdPersonYaw * gf_PI/180.0f));
		m_io.viewMtxFinal = Matrix33(viewParams.rotation);
	}

	if (m_io.bUsePivot)			
		viewParams.position += m_io.viewMtxFinal.GetColumn(1) * m_in.params_viewDistance + m_io.viewMtxFinal.GetColumn(2) * (0.25f + m_in.params_viewHeightOffset);
	else
		viewParams.position += m_io.viewMtxFinal.GetColumn(1) * -m_in.thirdPersonDistance + m_io.viewMtxFinal.GetColumn(2) * (0.25f + m_in.params_viewHeightOffset);
}

#if 0
void CPlayerView::ViewThirdPersonDirected(SViewParams &viewParams)
{
	if (m_in.thirdPersonYaw>0.001f)
	{
		viewParams.rotation *= Quat::CreateRotationXYZ(Ang3(0,0,m_in.thirdPersonYaw * gf_PI/180.0f));
		m_io.viewMtxFinal = Matrix33(viewParams.rotation);
	}

	if (m_io.bUsePivot)			
		viewParams.position += m_io.viewMtxFinal.GetColumn(1) * m_in.params_viewDistance + m_io.viewMtxFinal.GetColumn(2) * (0.25f + m_in.params_viewHeightOffset);
	else
		viewParams.position += m_io.viewMtxFinal.GetColumn(1) * -m_in.thirdPersonDistance + m_io.viewMtxFinal.GetColumn(2) * (0.25f + m_in.params_viewHeightOffset);
}
#endif

// jump/land spring effect. Adjust the eye and weapon pos as required.
void CPlayerView::FirstPersonJump(SViewParams &viewParams,Vec3 &weaponOffset)
{
	if (m_in.stats_inAir)
	{
		if (m_io.stats_jumped)
			m_io.eyeOffsetGoal.z -= 0.7f;

		if (m_in.stats_inAir>0.13f)
			m_io.stats_jumped = false;
	}
	else if (m_in.stats_onGround)
	{
		if (m_io.stats_landed)
		{
			m_io.eyeOffsetGoal.z -= (m_in.stance == STANCE_PRONE)?0.1f:0.3f;
			weaponOffset -= m_io.baseMtx.GetColumn(2) * 0.05f;
		}

		if (m_in.stats_onGround>0.1f)
			m_io.stats_landed = false;
	}
}

//
// Extract the various modifiers out into their own function.
//
// Aim is to make the code easier to understand and modify, as 
// well as to ease the addition of new modifiers.
//
void CPlayerView::ViewFirstPerson(SViewParams &viewParams)
{
		//headbob
		Vec3 bobGoal(0,0,0);
		Ang3 angOffset(0,0,0);
		Vec3 weaponOffset(0,0,0);
		Ang3 weaponAngleOffset(0,0,0);

		// jump/land spring effect. Adjust the eye and weapon pos as required.
		FirstPersonJump(viewParams,weaponOffset);

		//float standSpeed(GetStanceMaxSpeed(STANCE_STAND));

		Vec3 vSpeed(0,0,0);
		if (m_in.standSpeed>0.001f)
			vSpeed = (m_in.stats_velocity / m_in.standSpeed);

		float vSpeedLen(vSpeed.len());
		if (vSpeedLen>1.5f)
			vSpeed = vSpeed / vSpeedLen * 1.5f;

		// On the ground.
		if (m_in.stats_inAir < 0.1f)
		{
			float speedMul(0);
			if (m_in.standSpeed>0.001f)
				speedMul=(m_in.stats_flatSpeed / m_in.standSpeed * 1.1f);

			speedMul = min(1.5f,speedMul);


			//--- Bobbing.
			// bobCycle is a speed varying time step running (looping) from 0 to 1 
			// this feeds into a sin eqn creating a double horizontal figure of 8.
			// ( a lissajous figure with the vertical freq twice the horz freq ).

			// To tweak the total speed of the curve:

			// To tweak the effect speed has on the curve:
			const float kSpeedToBobFactor=1.25f;
			// To tweak the width of the bob:
			const float kBobWidth=0.1f;
			// To tweak the height of the bob:
			const float kBobHeight=0.05f;
			// To tweak the scale of strafing lag: (may need to manually adjust the strafing angle offsets as well.)
			const float kStrafeHorzScale=0.05f;


			m_io.stats_bobCycle += m_in.frameTime * kSpeedToBobFactor * speedMul;

			//if player is standing set the bob to rest. (bobCycle reaches 1.0f within 1 second)
			if (speedMul < 0.1f)
				m_io.stats_bobCycle = min(m_io.stats_bobCycle + m_in.frameTime * 1.0f,1.0f);

			// bobCycle loops between 0 and 1
			if (m_io.stats_bobCycle>1.0f)
				m_io.stats_bobCycle = m_io.stats_bobCycle - 1.0f;

			//set the bob offset
			Vec3 bobDir(cry_sinf(m_io.stats_bobCycle*gf_PI*2.0f)*kBobWidth*speedMul,0,cry_sinf(m_io.stats_bobCycle*gf_PI*4.0f)*kBobHeight*speedMul);
			bobGoal = m_io.viewMtxFinal * bobDir;

			//not the bob offset for the weapon
			bobDir *= 0.25f;

			//if player is strafing shift a bit the weapon on left/right
			if (speedMul > 0.01f)
			{
				// right vector dot speed vector
				float dot(m_io.viewMtxFinal.GetColumn(0) * vSpeed);

				bobDir.x -= dot * kStrafeHorzScale;	// the faster we move right, the more the gun lags to the left and vice versa

				//tweak the right strafe for weapon laser
				if (dot>0.0f)
					weaponAngleOffset.z += dot * 1.5f;	// kStrafeHorzScale
				else
					weaponAngleOffset.z -= dot * 2.0f;	// kStrafeHorzScale

				weaponAngleOffset.y += dot * 5.0f;		// kStrafeHorzScale
			}

			weaponOffset += m_io.viewMtxFinal * bobDir;
			weaponOffset -= m_io.baseMtx.GetColumn(2) * 0.035f * speedMul;

			weaponAngleOffset.y += cry_sinf(m_io.stats_bobCycle*gf_PI*2.0f) * speedMul * 1.5f;
			weaponAngleOffset.x += speedMul * 1.5f;

			//FIXME: viewAngles must include all the view offsets, otherwise aiming wont be precise.
			angOffset.x += cry_sinf(m_io.stats_bobCycle*gf_PI*4.0f)*0.7f*speedMul;
		}
		else
		{
			m_io.stats_bobCycle = 0;

			//while flying offset a bit the weapon model by the player speed	
			if (m_in.stats_velocity.len2()>0.001f)
			{				
				float dotFwd(m_io.viewMtxFinal.GetColumn(1) * vSpeed);
				float dotSide(m_io.viewMtxFinal.GetColumn(0) * vSpeed);
				float dotUp(m_io.viewMtxFinal.GetColumn(2) * vSpeed);

				weaponOffset += m_io.viewMtxFinal * Vec3(dotSide * -0.05f,dotFwd * -0.035f,dotUp * -0.05f);

				weaponAngleOffset.x += dotUp * 2.0f;
				weaponAngleOffset.y += dotSide * 5.0f;
				weaponAngleOffset.z -= dotSide * 2.0f;
			}
		}

		//add some inertia to weapon due view direction change.
		float deltaDotSide(m_io.vFPWeaponLastDirVec * m_io.viewMtxFinal.GetColumn(0));
		float deltaDotUp(m_io.vFPWeaponLastDirVec * m_io.viewMtxFinal.GetColumn(2));

		weaponOffset += m_io.viewMtxFinal * Vec3(deltaDotSide * 0.1f + m_in.stats_leanAmount * 0.05f,0,deltaDotUp * 0.1f - fabs(m_in.stats_leanAmount) * 0.05f) * m_in.params_weaponInertiaMultiplier;

		weaponAngleOffset.x -= deltaDotUp * 5.0f * m_in.params_weaponInertiaMultiplier;
		weaponAngleOffset.z += deltaDotSide * 5.0f * m_in.params_weaponInertiaMultiplier;
		weaponAngleOffset.y += deltaDotSide * 5.0f * m_in.params_weaponInertiaMultiplier;

		weaponAngleOffset.y += m_in.stats_leanAmount * 5.0f;
		//

		//apply some multipliers
		weaponOffset *= m_in.params_weaponBobbingMultiplier;
		bobGoal *= m_io.bobMul;

		Interpolate(m_io.vFPWeaponOffset,weaponOffset,7.0f,m_in.frameTime);
		Interpolate(m_io.vFPWeaponAngleOffset,weaponAngleOffset,7.0f,m_in.frameTime);
		Interpolate(m_io.vFPWeaponLastDirVec,m_io.viewMtxFinal.GetColumn(1),5.0f,m_in.frameTime);

		Interpolate(m_io.angleOffset,angOffset,10.0f,m_in.frameTime);
		Interpolate(m_io.bobOffset,bobGoal,7.0f,m_in.frameTime);

		viewParams.position += m_io.bobOffset;
}

void CPlayerView::ViewVehicle(SViewParams &viewParams)
{
	if (m_in.pVehicle)
	{
		m_in.pVehicle->UpdateView(viewParams, m_in.entityId);
		viewParams.viewID = 2;

		/*
		mathieu: do we need that code?

		Ang3 offset = m_io.viewAngleOffset;
		Vec3 viewDir = viewParams.rotation.GetColumn1();
		Matrix33 viewMat = Matrix33::CreateRotationVDir(viewDir);
		Matrix33 offmat = Matrix33::CreateRotationXYZ(offset);
		viewMat *= offmat;
		Quat rot = Quat::CreateRotationXYZ(Ang3::GetAnglesXYZ(viewMat));
		viewParams.rotation = rot;
		*/
	}
}

//FIXME:use the animated character view filter for this
void CPlayerView::ViewFollowCharacterFirstPerson(SViewParams &viewParams)
{
	viewParams.viewID = 3;

	//to avoid clipping
	viewParams.nearplane = 0.1f;
	viewParams.position = m_in.entityWorldMatrix *m_in.localEyePos;

	if (m_in.stats_isRagDoll)
		viewParams.position.z += 0.05f;

	if (m_in.stats_followCharacterHead)
	{
		viewParams.rotation = Quat(Matrix33(m_in.entityWorldMatrix)*m_in.headMtxLocal* Matrix33::CreateRotationY(gf_PI*0.5f));
	}
}

// View was set from an external source such as a vehicle, or followCharacterHead, so update the players rotation to match.
void CPlayerView::ViewExternalControlPostProcess(CPlayer &rPlayer,SViewParams &viewParams)
{
	// update the player rotation if view control is taken from somewhere else
	if (m_in.health>0 && (m_in.pVehicle || m_in.stats_followCharacterHead))
	{
		Vec3 forward = viewParams.rotation.GetColumn1().GetNormalizedSafe();
		Vec3 up = Vec3(0,0,1);

		m_io.baseMtx.SetFromVectors(forward % up,forward,up);
		//m_baseMtx.NoScale();

		m_io.viewMtx = m_io.viewMtxFinal = Matrix33(viewParams.rotation);
		//m_input.viewVector = viewParams.rotation.GetColumn1();
	}
}

// Position the first person weapons
void CPlayerView::FirstPersonWeaponPostProcess(CPlayer &rPlayer,SViewParams &viewParams)
{
	//set first person weapon position/rotation
	Vec3 shakeVec(viewParams.currentShakeShift *0.85f);
	m_io.stats_FPWeaponAngles = m_io.wAngles;
	m_io.stats_FPWeaponPos = viewParams.position + viewParams.blendPosOffset + m_io.vFPWeaponOffset + shakeVec;

	m_io.stats_FPSecWeaponAngles = m_io.wAngles;
	m_io.stats_FPSecWeaponPos = viewParams.position + m_io.vFPWeaponOffset + shakeVec;
}

// Shake the view as requested
void CPlayerView::ViewShakePostProcess(CPlayer &rPlayer,SViewParams &viewParams)
{
#if 0
	if (m_io.viewShake.amount>0.001f)
	{
		viewParams.shakeDuration = m_io.viewShake.duration;
		viewParams.shakeFrequency = m_io.viewShake.frequency;
		viewParams.shakeAmount = m_io.viewShake.angle;
		viewParams.shakeID = 1;

		memset(&m_io.viewShake,0,sizeof(SViewShake));
	}
	/*else if (IsZeroG() && m_stats.flatSpeed > 10.0f)
	{
	viewParams.shakeDuration = 0.1f;
	viewParams.shakeFrequency = 0.1f;
	viewParams.shakeAmount = Ang3(m_stats.flatSpeed*0.001f,0,0);
	}*/
	else if (m_in.stats_inAir < 0.1f && m_in.stats_flatSpeed > m_in.stand_MaxSpeed * 1.1f)
	{
		viewParams.shakeDuration = 0.1f ;/// (shake*shake);
		viewParams.shakeFrequency = 0.1f ;/// (shake*shake);
		viewParams.shakeAmount = Ang3(m_in.stats_flatSpeed*0.0015f,m_in.stats_flatSpeed*0.00035f,m_in.stats_flatSpeed*0.00035f) * m_in.shake;
		viewParams.shakeID = 0;
	}
#endif
	//testing code
	/*if (m_stats.inAir < 0.1f && m_stats.flatSpeed > GetStanceInfo(STANCE_STAND)->maxSpeed * 1.1f)
	{
	float shake(GetISystem()->GetIConsole()->GetCVar("cl_sprintShake")->GetFVal());

	IView *pView = g_pGame->GetIGameFramework()->GetIViewSystem()->GetViewByEntityId(GetEntityId());
	if (pView)
	pView->SetViewShake(ZERO,Vec3(m_stats.flatSpeed*0.0035f,0,m_stats.flatSpeed*0.0035f) * shake,0.1f,0.05f,0.5f,1);
	}*/
}

// Locate the HUD in 3d space so that it appears correctly on screen.
void CPlayerView::HudPostProcess(CPlayer &rPlayer,SViewParams &viewParams)
{
	Quat hudQuat(Matrix33(viewParams.rotation) * Matrix33::CreateRotationXYZ(m_in.params_hudAngleOffset));
	hudQuat *= Quat::CreateSlerp(viewParams.currentShakeQuat,IDENTITY,0.05f);
	hudQuat.Normalize();

	Matrix33 hudMtx(hudQuat);

	rPlayer.m_stats.HUDAngles = Ang3::GetAnglesXYZ(hudMtx);
	rPlayer.m_stats.HUDPos = viewParams.position - rPlayer.m_FPWeaponOffset * 0.3f;
	rPlayer.m_stats.HUDPos += hudMtx.GetColumn(2)*rPlayer.m_params.hudOffset.z;
	rPlayer.m_stats.HUDPos += hudMtx.GetColumn(1)*rPlayer.m_params.hudOffset.y;
	rPlayer.m_stats.HUDPos += hudMtx.GetColumn(0)*rPlayer.m_params.hudOffset.x;

	Script::CallMethod(rPlayer.GetEntity()->GetScriptTable(), "OnUpdateView", m_in.frameTime);

	GetISystem()->GetIGame()->GetIGameFramework()->GetIGameTokenSystem()->SetOrCreateToken("hud.offsetx",TFlowInputData(rPlayer.m_FPWeaponOffset.x,true));
	GetISystem()->GetIGame()->GetIGameFramework()->GetIGameTokenSystem()->SetOrCreateToken("hud.offsety",TFlowInputData(rPlayer.m_FPWeaponOffset.z,true));
}

// If there are first person hands present, then position and orient them relative to the view
void CPlayerView::HandsPostProcess(CPlayer &rPlayer,SViewParams &viewParams)
{
	//for testing sake
	float nearPlaneOverride(g_pGame->GetCVars()->cl_nearPlane->GetFVal());
	if (nearPlaneOverride > 0.001f)
		viewParams.nearplane = nearPlaneOverride;

	//FIXME:find a better place?
	// Convention: if Player has a renderable object in slot 2 then it's the first person hands.
	if (rPlayer.GetEntity()->GetSlotFlags(2) & ENTITY_SLOT_RENDER)
	{
		Matrix34 handsMtx(rPlayer.m_viewMtxFinal * Matrix33::CreateRotationZ(gf_PI),viewParams.position);
		rPlayer.GetEntity()->SetSlotLocalTM(2,rPlayer.GetEntity()->GetWorldTM().GetInverted() * handsMtx);
		ICharacterInstance *pHands = rPlayer.GetEntity()->GetCharacter(2);
		if (pHands)
		{
			pHands->GetISkeleton()->SetAlwaysUpdate(1);
			pHands->Update(handsMtx, GetISystem()->GetViewCamera(), 0);
		}
	}
}
