/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Projectile

-------------------------------------------------------------------------
History:
- 12:10:2005   11:15 : Created by Mrcio Martins

*************************************************************************/
#ifndef __PROJECTILE_H__
#define __PROJECTILE_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <IGameObject.h>
#include "IItemSystem.h"
#include "ItemParamReader.h"
#include "TracerManager.h"

#define MIN_STICKY_POINTS					2
#define MAX_STICKY_POINTS					4
#define MAX_STICKY_BADCOLLISIONS	20
#define STICKY_TIMER							125

struct IItemParamsNode;
class CProjectile :
	public CGameObjectExtensionHelper<CProjectile, IGameObjectExtension>
{
public:
	enum ProjectileTimer
	{
		ePTIMER_LIFETIME	= 0x110,
		ePTIMER_SHOWTIME	= 0x111,
		ePTIMER_STICKY		= 0x112,
	};
	CProjectile();
	virtual ~CProjectile();

	// IGameObjectExtension
	virtual bool Init(IGameObject *pGameObject);
	virtual void InitClient(int channelId) {};
	virtual void PostInit(IGameObject *pGameObject);
	virtual void PostInitClient(int channelId) {};
	virtual void Release();
	virtual void Serialize(TSerialize ser, unsigned aspects);
	virtual void Update( SEntityUpdateContext &ctx, int updateSlot);
	virtual void PostUpdate(float frameTime ) {};
	virtual void HandleEvent( const SGameObjectEvent &);
	virtual void ProcessEvent(SEntityEvent &);
	virtual IEntity *GetEntity();
	virtual void SetChannelId(uint16 id) {};
	virtual void SetAuthority(bool auth);
	//~IGameObjectExtension

	virtual void LoadGeometry();
	virtual void Physicalize(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity);
	virtual void SetParams(EntityId ownerId, EntityId weaponId, int damage);
  virtual void SetDestination(const Vec3& pos){}
  virtual void SetDestination(EntityId targetId){}
	virtual void SetTracerPath(CTracerPath *path);
	virtual void Launch(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity);  
	virtual void Destroy();
	virtual bool WaterCollision(const Vec3 &current, const Vec3 &last);
	virtual bool IsRemote() const;
	virtual void SetRemote(bool remote);
	
	virtual void Explode(bool destroy);
	virtual void TrailSound(bool enable, const Vec3 &dir=Vec3(0.0f,1.0f,0.0f));
	virtual void WhizSound(bool enable, const Vec3 &pos);
	virtual void TrailEffect(bool enable);

	virtual int AttachEffect(bool attach, int id, const char *name=0, const Vec3 &offset=Vec3(0.0f,0.0f,0.0f), const Vec3 &dir=Vec3(0.0f,1.0f,0.0f), float scale=1.0f);

	virtual void Stick(EventPhysCollision *pCollision);
	virtual void Unstick();
protected:
	IEntitySoundProxy *GetSoundProxy();
	template<typename T> T GetParam(const char *name, T &def)
	{
		T v(def);
		const IItemParamsNode *params = m_params->GetChild("params");
		if (params)
		{
			CItemParamReader reader(params);
			reader.Read(name, v);
		}
		return v;
	}
	
	const IItemParamsNode *m_params;
	IGameObject			*m_pGameObject;
	IEntity					*m_pEntity;
	IPhysicalEntity *m_pPhysicalEntity;
	int				m_whizSoundId;
	int				m_trailSoundId;
	int				m_trailEffectId;
	Vec3			m_last;

	bool			m_sticky;
	int				m_stuck;
	int				m_constraints[MAX_STICKY_POINTS];
	Vec3			m_constraintspt[MAX_STICKY_POINTS];
	int				m_stickyCollisions;
	
	IPhysicalEntity *m_pStickyBuddy;

	float			m_mass;

	EntityId	m_ownerId;
	EntityId	m_weaponId;
	int				m_damage;
	bool			m_destroying;

	bool			m_remote;

	CTracerPath	*m_tracerpath;
};


#endif