/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 11:9:2005   15:00 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Rapid.h"
#include "Actor.h"
#include "Player.h"
#include "ISound.h"
#include "Game.h"
#include <IViewSystem.h>


//------------------------------------------------------------------------
CRapid::CRapid()
{
}

//------------------------------------------------------------------------
CRapid::~CRapid()
{
}

//------------------------------------------------------------------------
void CRapid::ResetParams(const struct IItemParamsNode *params)
{
	CSingle::ResetParams(params);

	const IItemParamsNode *actions = params?params->GetChild("actions"):0;
	const IItemParamsNode *rapid = params?params->GetChild("rapid"):0;
	
	m_rapidactions.Reset(actions);
	m_rapidparams.Reset(rapid);
}

//------------------------------------------------------------------------
void CRapid::PatchParams(const struct IItemParamsNode *patch)
{
	CSingle::PatchParams(patch);
  
	const IItemParamsNode *actions = patch->GetChild("actions");
	const IItemParamsNode *rapid = patch->GetChild("rapid");

	m_rapidactions.Reset(actions, false);
	m_rapidparams.Reset(rapid, false);
}

//------------------------------------------------------------------------
void CRapid::Activate(bool activate)
{
	CSingle::Activate(activate);

	if (activate)
	{
		m_pWeapon->RequireUpdate(true);
		m_pWeapon->EnableUpdate(true);
	}
	else
	{
		m_pWeapon->RequireUpdate(false);
		if (m_soundId != INVALID_SOUNDID)
		{
			m_pWeapon->StopSound(m_soundId);
			m_soundId = INVALID_SOUNDID;
		}
	}

	m_rotation_angle = 0.0f;
	m_speed = 0.0f;
	m_accelerating = false;
	m_decelerating = false;
	m_acceleration = 0.0f;

	m_soundId = INVALID_SOUNDID;
	m_spinUpSoundId = INVALID_SOUNDID;

	Firing(false);
}

//------------------------------------------------------------------------
void CRapid::Update(float frameTime, uint frameId)
{
  FUNCTION_PROFILER( GetISystem(), PROFILE_GAME );

	CSingle::Update(frameTime, frameId);

	if ((m_speed <= 0.0f) && (m_acceleration < 0.0f))
	{
		m_decelerating = false;
		m_speed = 0.0f;
		return;
	}

	m_speed = m_speed + m_acceleration*frameTime;
	if (m_speed > m_rapidparams.max_speed)
	{
		m_speed = m_rapidparams.max_speed;
		m_accelerating = false;
	}

	if ((m_speed >= m_rapidparams.min_speed) && (!m_decelerating))
	{
		float dt = m_speed/m_rapidparams.max_speed;
		m_next_shot_dt = 60.0f/(m_fireparams.rate*(dt+0.001f));

		bool canShoot = CanFire(false);

		if (canShoot)
		{
			if (!OutOfAmmo())
			{
				Firing(Shoot(true, false));
				if (m_firing)
				{
					CActor *act = m_pWeapon->GetOwnerActor();
					if (act && act->IsPlayer())
					{
						CPlayer *plr = (CPlayer *)act;
						Vec3 z = ZERO;
						IView *pView = g_pGame->GetIGameFramework()->GetIViewSystem()->GetViewByEntityId(act->GetEntityId());
						// .005
						float rotX = GetISystem()->GetIConsole()->GetCVar("h_rX")->GetFVal();
						float rotY = GetISystem()->GetIConsole()->GetCVar("h_rY")->GetFVal();
						float rotZ = GetISystem()->GetIConsole()->GetCVar("h_rZ")->GetFVal();

						float shiftX = GetISystem()->GetIConsole()->GetCVar("h_sX")->GetFVal();
						float shiftY = GetISystem()->GetIConsole()->GetCVar("h_sY")->GetFVal();
						float shiftZ = GetISystem()->GetIConsole()->GetCVar("h_sZ")->GetFVal();

						float rand = GetISystem()->GetIConsole()->GetCVar("h_rand")->GetFVal();
				
						//pView->SetViewShake(ZERO, Vec3(0, 0, .1f), m_next_shot_dt/2.0f, m_next_shot_dt/2.0f, 1.0f, 1);
						pView->SetViewShake(Vec3(rotX, rotY, rotZ), Vec3(shiftX, shiftY, shiftZ), m_next_shot_dt/4.0f, m_next_shot_dt/4.0f, rand, 1);
						//plr->CameraShake(1.8f, 0.0f, m_next_shot_dt/8.0f, m_next_shot_dt/8.0f, z, 1);
					}
					
				}
			}
			else
			{
				Firing(false);
				Accelerate(m_rapidparams.deceleration);
				m_pWeapon->Reload();
			}
		}
	}
	else if (m_firing)
	{
		Firing(false);
	}

	if ((m_speed < m_rapidparams.min_speed) && (m_acceleration < 0.0f) && (!m_decelerating))
		Accelerate(m_rapidparams.deceleration);

	UpdateRotation(frameTime);
	UpdateSound(frameTime);
}

//------------------------------------------------------------------------
void CRapid::StartReload(bool zoomed)
{
	Firing(false);
	Accelerate(m_rapidparams.deceleration);

	CSingle::StartReload(zoomed);
}

//------------------------------------------------------------------------
void CRapid::StartFire(EntityId shooterId)
{
	if (m_pWeapon->IsBusy() || !CanFire(true))
		return;

	m_shooterId = shooterId;

	m_pWeapon->EnableUpdate(true);

	SpinUpEffect(true);
	Accelerate(m_rapidparams.acceleration);
}

//------------------------------------------------------------------------
void CRapid::StopFire(EntityId shooterId)
{
	if (m_pWeapon->IsBusy())
		return;
	if (m_zoomtimeout > 0.0f)
	{
		ICVar *zoomouttime = GetISystem()->GetIConsole()->GetCVar("int_ZoomOutTime");
		ICVar *zoomamount = GetISystem()->GetIConsole()->GetCVar("int_ZoomAmount");
		CActor *pActor = m_pWeapon->GetOwnerActor();
		if (pActor)
			pActor->GetIntensityMonitor()->ChangeFOV(1.0f, zoomouttime->GetFVal(), true, 1.0f - zoomamount->GetFVal());
		m_zoomtimeout = 0.0f;
	}
	if((m_speed > 0.0f) && (m_acceleration >= 0.0f))
		Accelerate(m_rapidparams.deceleration);
}

//------------------------------------------------------------------------
float CRapid::GetSpinUpTime() const
{
	return m_rapidparams.min_speed/m_rapidparams.acceleration;
}

//------------------------------------------------------------------------
float CRapid::GetSpinDownTime() const
{
	return m_rapidparams.max_speed/m_rapidparams.deceleration;
}

//------------------------------------------------------------------------
void CRapid::Accelerate(float acc)
{
	m_acceleration = acc;

	if (acc > 0.0f)
	{
		m_accelerating = true;
		m_decelerating = false;
		m_spinUpSoundId = m_pWeapon->PlayAction(m_actions.spin_up.c_str(), 0, false, CItem::eIPAF_Default|CItem::eIPAF_CleanBlending);
	}
	else
	{
		m_accelerating = false;
		m_decelerating = true;
		m_pWeapon->PlayAction(m_actions.spin_down.c_str(), 0, false, CItem::eIPAF_Default|CItem::eIPAF_CleanBlending);

		if (m_spinUpSoundId != INVALID_SOUNDID)
		{
			m_pWeapon->StopSound(m_spinUpSoundId);
			m_spinUpSoundId = INVALID_SOUNDID;
		}
		
		SpinUpEffect(false);
	}
}

//------------------------------------------------------------------------
void CRapid::Firing(bool firing)
{
	SpinUpEffect(false);

	if (m_firing != firing)
	{
		if (!m_firing)
			m_pWeapon->PlayAction(m_rapidactions.blast.c_str());
		MuzzleFlashEffect(firing);
	}
	m_firing = firing;
}

//------------------------------------------------------------------------
void CRapid::UpdateRotation(float frameTime)
{
	m_rotation_angle -= m_speed*frameTime*2.0f*3.141592f;
	Ang3 angles(0,m_rotation_angle,0);

	Matrix34 tm = Matrix33::CreateRotationXYZ(angles);
	m_pWeapon->SetCharacterAttachmentLocalTM(CItem::eIGS_FirstPerson, m_rapidparams.barrel_attachment.c_str(), tm);
	m_pWeapon->SetCharacterAttachmentLocalTM(CItem::eIGS_FirstPerson, m_rapidparams.engine_attachment.c_str(), tm);
}

//------------------------------------------------------------------------
void CRapid::UpdateSound(float frameTime)
{
	if (m_speed > 0.001f)
	{
		if (m_soundId == INVALID_SOUNDID)
			m_soundId = m_pWeapon->PlayAction(m_rapidactions.	rapid_fire.c_str(), 0, true, CItem::eIPAF_Default&(~CItem::eIPAF_Animation));

		if (m_soundId != INVALID_SOUNDID)
		{
			float rpm_scale = m_speed/m_rapidparams.min_speed;
			float ammo = 0;

			if (!OutOfAmmo())
				ammo = 1.0f;

			ISound *pSound = m_pWeapon->GetISound(m_soundId);
			if (pSound)
			{
				pSound->SetParam("rpm_scale", rpm_scale);
				pSound->SetParam("ammo", ammo);
			}

			if (m_speed>=m_rapidparams.min_speed)
				m_spinUpSoundId = INVALID_SOUNDID;
		}
	}
	else if (m_soundId != INVALID_SOUNDID)
	{
		m_pWeapon->StopSound(m_soundId);
		m_soundId = INVALID_SOUNDID;
	}
}

Vec3 CRapid::ApplySpread(const Vec3 &dir)
{
	float spread = m_spread;
	Vec3 up = ZERO;
	Vec3 right = ZERO;
	Vec3 finalDir = dir;
	Matrix33 mat = Matrix33::CreateRotationXYZ(Ang3::GetAnglesXYZ(Quat::CreateRotationVDir(dir)));
	right = mat.GetColumn(0).normalize();
	up = mat.GetColumn(2).normalize();
	finalDir = Random(-1.0f, 1.0f) * spread * right + Random(-1.0f, 1.0f) * spread * up + dir;
	return finalDir;
}