/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Rapid Fire Mode Implementation

-------------------------------------------------------------------------
History:
- 26:10:2005   14:15 : Created by Mrcio Martins

*************************************************************************/
#ifndef __RAPID_H__
#define __RAPID_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "Single.h"


class CRapid : public CSingle
{
protected:
	typedef struct SRapidParams
	{
		SRapidParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(min_speed,	1.5f);
			ResetValue(max_speed,	3.0f);
			ResetValue(acceleration,	3.0f);
			ResetValue(deceleration,	-3.0f);
			ResetValue(barrel_attachment,	"barrel");
			ResetValue(engine_attachment,	"engine");
		}

		float min_speed;
		float max_speed;
		float acceleration;
		float	deceleration;
		string barrel_attachment;
		string engine_attachment;

	} SRapidParams;

	typedef struct SRapidActions
	{
		SRapidActions() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(rapid_fire,"rapid_fire");
			ResetValue(blast,			"blast");
		}

		string rapid_fire;
		string blast;

	} SRapidActions;

public:
	CRapid();
	virtual ~CRapid();

	// CSingle
	virtual void Update(float frameTime, uint frameId);

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual void Activate(bool activate);

	virtual void StartReload(bool zoomed);

	virtual void StartFire(EntityId shooterId);
	virtual void StopFire(EntityId shooterId);

	virtual float GetSpinUpTime() const;
	virtual float GetSpinDownTime() const;

	virtual Vec3 ApplySpread(const Vec3 &dir);
	// ~CSingle

protected:
	virtual void Accelerate(float acc);
	virtual void Firing(bool firing);
	virtual void UpdateRotation(float frameTime);
	virtual void UpdateSound(float frameTime);

	SRapidActions m_rapidactions;
	SRapidParams	m_rapidparams;

	float	m_speed;
	float	m_acceleration;
	float m_rotation_angle;

	bool	m_accelerating;
	bool	m_decelerating;

	uint	m_soundId;
	uint	m_spinUpSoundId;

};


#endif