/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 28:10:2005   16:00 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Scope.h"
#include "Player.h"


//------------------------------------------------------------------------
void CScope::Update(float frameTime, uint frameId)
{
	CIronSight::Update(frameTime, frameId);

	if (m_showTimer>0.0f)
	{
		m_showTimer-=frameTime;
		if (m_showTimer<=0.0f)
		{
			m_showTimer=0.0f;
			m_pWeapon->Hide(false);
		}
	}
}

//------------------------------------------------------------------------
void CScope::ResetParams(const struct IItemParamsNode *params)
{
	CIronSight::ResetParams(params);

	const IItemParamsNode *scope = params?params->GetChild("scope"):0;
	m_scopeparams.Reset(scope);
}

//------------------------------------------------------------------------
void CScope::PatchParams(const struct IItemParamsNode *patch)
{
	CIronSight::PatchParams(patch);

	const IItemParamsNode *scope = patch->GetChild("scope");
	m_scopeparams.Reset(scope, false);
}

//------------------------------------------------------------------------
void CScope::Activate(bool activate)
{
	if (!activate)
	{
		if (m_zoomed || m_zoomTimer>0.0f)
		{
			IScriptSystem *pScriptSystem = GetISystem()->GetIScriptSystem();
			HSCRIPTFUNCTION func = 0;
			if (pScriptSystem->GetGlobalValue("WeaponResetScope", func))
			{
				Script::Call(pScriptSystem, func, m_scopeparams.scope.c_str());
				pScriptSystem->ReleaseFunc(func);
			}
		}
	}

	CIronSight::Activate(activate);
}

//------------------------------------------------------------------------
void CScope::OnZoomedIn()
{
	CIronSight::OnZoomedIn();
	m_pWeapon->Hide(true);
}

//------------------------------------------------------------------------
void CScope::OnEnterZoom()
{
	IScriptSystem *pScriptSystem = GetISystem()->GetIScriptSystem();
	HSCRIPTFUNCTION func = 0;
	if (pScriptSystem->GetGlobalValue("WeaponActivateScope", func))
	{
		Script::Call(pScriptSystem, func, m_scopeparams.scope.c_str(), ScriptHandle(m_pWeapon->GetEntityId()), true,
			m_scopeparams.dark_in_time, m_zoomparams.zoom_in_time);
		pScriptSystem->ReleaseFunc(func);
	}
}

//------------------------------------------------------------------------
void CScope::OnLeaveZoom()
{
	m_showTimer = 0.15f;

	IScriptSystem *pScriptSystem = GetISystem()->GetIScriptSystem();
	HSCRIPTFUNCTION func = 0;
	if (pScriptSystem->GetGlobalValue("WeaponActivateScope", func))
	{
		Script::Call(pScriptSystem, func, m_scopeparams.scope.c_str(), ScriptHandle(m_pWeapon->GetEntityId()), false,
			m_scopeparams.dark_out_time, m_zoomparams.zoom_out_time);
		pScriptSystem->ReleaseFunc(func);
	}

	ClearDoF();
}

void CScope::OnZoomedOut()
{
	CActor *pActor = m_pWeapon->GetOwnerActor();
	if (pActor)
	{
		m_pWeapon->GetOwnerActor()->GetIntensityMonitor()->Enable(true);
		m_pWeapon->GetOwnerActor()->GetIntensityMonitor()->ChangeFOV(1.0f, 0.0f);
	}
	// marcok: hacky ... I know
	if (!strcmp(m_pWeapon->GetEntity()->GetClass()->GetName(), "Binoculars"))
	{
		if (!m_pWeapon->GetOwnerActor())
			return;

		m_pWeapon->GetOwnerActor()->SelectLastItem(false);
	}
}