/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Script Binding for Item
  
 -------------------------------------------------------------------------
  History:
  - 27:10:2004   11:30 : Created by Mrcio Martins

*************************************************************************/
#ifndef __SCRIPTBIND_ITEM_H__
#define __SCRIPTBIND_ITEM_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <IScriptSystem.h>
#include <ScriptHelpers.h>


struct IItemSystem;
struct IGameFramework;
class CItem;


class CScriptBind_Item :
	public CScriptableBase
{
public:
	CScriptBind_Item(ISystem *pSystem, IGameFramework *pGameFramework);
	virtual ~CScriptBind_Item();

	void AttachTo(CItem *pItem);

	int SetExtensionActivation(IFunctionHandler *pH, const char *extension, bool activation);
	int SetExtensionParams(IFunctionHandler* pH, const char *extension, SmartScriptTable params);
	int GetExtensionParams(IFunctionHandler* pH, const char *extension, SmartScriptTable params);

	int Select(IFunctionHandler *pH, bool select);
	int GetStats(IFunctionHandler *pH);
	int GetParams(IFunctionHandler *pH);

	int Quiet(IFunctionHandler *pH);

	int CanPickUp(IFunctionHandler *pH, ScriptHandle userId);
	int CanUse(IFunctionHandler *pH, ScriptHandle userId);
	int IsMounted(IFunctionHandler *pH);
	
	int PlayAction(IFunctionHandler *pH, const char *actionName);

	int GetOwnerId(IFunctionHandler *pH);
	int StartUse(IFunctionHandler *pH, ScriptHandle userId);
	int StopUse(IFunctionHandler *pH, ScriptHandle userId);
	int Use(IFunctionHandler *pH, ScriptHandle userId);
	int IsUsed(IFunctionHandler *pH);

	int GetMountedDir(IFunctionHandler *pH);
	int GetMountedAngleLimits(IFunctionHandler *pH);

	int Freeze(IFunctionHandler *pH, bool freeze);

private:
	void RegisterGlobals();
	void RegisterMethods();

	CItem *GetItem(IFunctionHandler *pH);

	ISystem						*m_pSystem;
	IScriptSystem			*m_pSS;
	IGameFramework		*m_pGameFW;

	SmartScriptTable	m_stats;
	SmartScriptTable	m_params;
};


#endif //__SCRIPTBIND_ITEM_H__