/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------

Description: Utilities for working with the Script system

-------------------------------------------------------------------------
History:
-	29:03:2006  : Created by Matthew Jack

*************************************************************************/

#ifndef __SCRIPTUTILS_H__
#define __SCRIPTUTILS_H__

#pragma once

#include "IScriptSystem.h"

//-------------------------------------------------------------------------

// Test equality independantly of type, trying to mirror LUA equality
bool IsEqual(ScriptAnyValue &a, ScriptAnyValue &b);

template <class T> bool IsEqual(ScriptAnyValue &a, T &b) {
	ScriptAnyValue(b);	
	return IsEqual(a,b);
}

template <class T> bool IsEqual(T &a, ScriptAnyValue &b){
	ScriptAnyValue(b);
	return IsEqual(a,b);
}

// Convert to a string representation
string ToString(ScriptAnyValue &value);

// Badly named?
// Get a LUA value by a full path
bool GetLuaVarRecursive(const char *sKey, ScriptAnyValue &result);

// Set a LUA value by a full path
bool SetLuaVarRecursive(const char *sKey, const ScriptAnyValue &newValue);


// Dump a table out to a file stream as LUA code
bool DumpLuaTable( IScriptTable * table, FILE * file, string &str);


#endif __SCRIPTUTILS_H__