#include "StdAfx.h"
#include "Shotgun.h"
#include "Game.h"
#include "WeaponSystem.h"
#include "Actor.h"

CShotgun::CShotgun(void)
{
}

CShotgun::~CShotgun(void)
{
}

void CShotgun::Reload(bool zoomed)
{
	StartReload(zoomed);
}

// Move shotgun into reloading pose
void CShotgun::StartReload(bool zoomed)
{
	int ammoCount = m_pWeapon->GetAmmoCount(m_fireparams.ammo_type.c_str());
	if (ammoCount == m_fireparams.clip_size)
		return;

	m_reloading = true;
	if (zoomed)
		m_pWeapon->ExitZoom();
	m_pWeapon->SetBusy(true);

	m_pWeapon->PlayAction("begin_reload", 0, false, CItem::eIPAF_Default|CItem::eIPAF_RepeatLastFrame);

	struct BeginReloadLoop: public ISchedulerAction
	{
		BeginReloadLoop(CShotgun *_shotty, bool _zoomed, bool _pump): shotty(_shotty), zoomed(_zoomed), pump(_pump) {};
		CShotgun *shotty;
		bool zoomed;
		bool pump;

		virtual void execute(CItem *_this)
		{
			shotty->ReloadShell(zoomed, pump);
		}
	};
	bool pump = ammoCount > 0 ? false : true;
	uint animTime = m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson);
	m_pWeapon->GetScheduler()->TimerAction(animTime, new BeginReloadLoop(this, zoomed, pump), false);

	struct SliderBack: public ISchedulerAction
	{
		SliderBack(CShotgun *_shotgun): shotgun(_shotgun) {};
		CShotgun *shotgun;

		virtual void execute(CItem *_this)
		{
			_this->StopLayer(shotgun->m_fireparams.slider_layer.c_str());
		}
	};
	m_pWeapon->GetScheduler()->TimerAction((uint)((m_fireparams.reload_time-0.125f)*1000), new SliderBack(this), false);
}

// Reload shells
void CShotgun::ReloadShell(bool zoomed, bool pump)
{
	int ammoCount = m_pWeapon->GetAmmoCount(m_fireparams.ammo_type.c_str());
	if (ammoCount != m_fireparams.clip_size)
	{
		// reload a shell
		m_pWeapon->PlayAction("reload_shell", 0, false, CItem::eIPAF_Default|CItem::eIPAF_RepeatLastFrame|CItem::eIPAF_RestartAnimation);
		class ReloadOneShellAction : public ISchedulerAction
		{
		public:
			ReloadOneShellAction(CWeapon *_wep, bool _zoomed, bool _pump)
			{
				pWep = _wep;
				rzoomed = _zoomed;
				rpump = _pump;
			}
			virtual void execute(CItem *_this)
			{
				CShotgun *fm = (CShotgun *)pWep->GetFireMode(pWep->GetCurrentFireMode());
				const char *ammoType = fm->GetAmmoType();
				int ammoCount = pWep->GetAmmoCount(ammoType);
				pWep->SetAmmoCount(ammoType, ammoCount+1);
				fm->ReloadShell(rzoomed, rpump);
			}
		private:
			CWeapon *pWep;
			bool rzoomed;
			bool rpump;
		};
		uint animTime = m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson);
		m_pWeapon->GetScheduler()->TimerAction(animTime, new ReloadOneShellAction(m_pWeapon, zoomed, pump), false);
		// call this again
		
	}
	else
	{
		EndReload(zoomed, pump);
	}

	
}

// Move shotgun out of reloading pose
void CShotgun::EndReload(bool zoomed, bool pump)
{
	CActor *pActor = m_pWeapon->GetOwnerActor();

	// reload anim depends on if we were empty
	/*
	if (m_fireparams.bullet_chamber)
	{
		int ammoCount = m_pWeapon->GetAmmoCount(ammo);
		if ((ammoCount>0) && (ammoCount < m_fireparams.clip_size))
			action = m_actions.reload_chamber_full.c_str();
		else
			action = m_actions.reload_chamber_empty.c_str();
	}
	*/
	if (pump)
		m_pWeapon->PlayAction("exit_reload_pump");
	else
		m_pWeapon->PlayAction("exit_reload_nopump");
	m_reloading = false;
	m_emptyclip = false;
	m_ammoid = 0;
	m_spinUpTime = m_firing?m_fireparams.spin_up_time:0.0f;



/*
	const char *ammo = m_fireparams.ammo_type.c_str();

	
	int ammoCount = m_pWeapon->GetAmmoCount(ammo);
	if (m_fireparams.bullet_chamber && (ammoCount>0) && (ammoCount<m_fireparams.clip_size))
		ammoCount = m_fireparams.clip_size+1;
	else
		ammoCount = m_fireparams.clip_size;

	m_pWeapon->SetAmmoCount(ammo, ammoCount);
	m_pWeapon->SetClipCount(ammo, m_pWeapon->GetClipCount(ammo)-1);
	*/

	m_pWeapon->SetBusy(false);
	if (zoomed)
		m_pWeapon->StartZoom(m_pWeapon->GetOwnerId());
}

bool CShotgun::Shoot(bool resetAnimation, bool autoreload/* =true */)
{
	const char *ammo = m_fireparams.ammo_type.c_str();
	int ammoCount = m_pWeapon->GetAmmoCount(ammo);

	if (!CanFire(true))
	{
		if ((ammoCount <= 0) && (!m_reloading))
		{
			/*if (!m_emptyclip)
			{
			m_emptyclip = true;
			m_pWeapon->PlayAction(m_actions.empty_clip.c_str());

			return true;
			}
			else if (CanReload())
			{
			m_pWeapon->PlayAction(m_actions.empty_clip.c_str());
			m_pWeapon->Reload();

			return true;
			}
			*/
		}

		return false;
	}

	const char *action = m_actions.fire_cock.c_str();
	if (ammoCount == 1)
		action = m_actions.fire.c_str();

	if (resetAnimation)
		m_pWeapon->ResetAnimation();
	m_pWeapon->PlayAction(action, 0, false, CItem::eIPAF_Default|CItem::eIPAF_NoBlend);

	Vec3 hit = GetProbableHit(WEAPON_HIT_RANGE);
	Vec3 pos = GetFiringPos(hit);
	Vec3 dir = ApplySpread(GetFiringDir(hit));
	Vec3 vel = GetFiringVelocity();

	// SHOT HERE
	for (int i = 0; i < m_shotgunparams.pellets; i++)
	{
		CProjectile *pAmmo = m_pWeapon->SpawnAmmo(ammo);
		if (pAmmo)
		{
			pAmmo->SetParams(m_shooterId, m_pWeapon->GetEntityId(), m_shotgunparams.pelletdamage);
			pAmmo->SetDestination(m_pWeapon->GetDestination());
			pAmmo->Launch(pos, dir, vel);

			if ((!m_tracerparams.geometry.empty() || !m_tracerparams.effect.empty()) && (!m_ammoid || (m_ammoid%m_tracerparams.frequency==0)))
			{
				CTracerPath path;
				path.AddPoint(hit);

				CTracerManager::STracerParams params;
				params.geometry = m_tracerparams.geometry.c_str();
				params.effect = m_tracerparams.effect.c_str();
				params.path = &path;
				params.position = pos;
				params.scale = m_tracerparams.scale;
				params.speed = m_tracerparams.speed;
				params.lifetime = m_tracerparams.lifetime;

				path.First();
				g_pGame->GetWeaponSystem()->GetTracerManager().EmitTracer(params);
			}

			m_projectileId = pAmmo->GetEntity()->GetId();
			++m_ammoid;
		}
		hit = GetProbableHit(WEAPON_HIT_RANGE);
		pos = GetFiringPos(hit);
		dir = ApplySpread(GetFiringDir(hit));
		vel = GetFiringVelocity();
		m_pWeapon->OnShoot(m_shooterId, pAmmo?pAmmo->GetEntity()->GetId():0, ammo, pos, dir, vel);
	}


	

	MuzzleFlashEffect(true);

	m_fired = true;
	m_next_shot += m_next_shot_dt;
	m_zoomtimeout = m_next_shot + 0.5f;
	ammoCount--;

	m_pWeapon->SetAmmoCount(ammo, ammoCount);
	if ((ammoCount<1) && !m_fireparams.slider_layer.empty())
	{
		const char *slider_back_layer = m_fireparams.slider_layer.c_str();
		m_pWeapon->PlayLayer(slider_back_layer, CItem::eIPAF_Default|CItem::eIPAF_NoBlend);
	}

	if (OutOfAmmo())
	{
		m_pWeapon->OnOutOfAmmo(ammo);
		if (autoreload)
		{
			class ScheduleReload : public ISchedulerAction {
			public:
				ScheduleReload(CWeapon *wep)
				{
					_pWeapon = wep;
				}
				virtual ~ScheduleReload()
				{

				}
				virtual void execute(CItem *item) {
					_pWeapon->Reload();
					//delete this;
				}
			private:
				CWeapon *_pWeapon;
			};
			m_pWeapon->GetScheduler()->TimerAction(m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson), new ScheduleReload(m_pWeapon), false);
		}
	}

	if (m_pWeapon->GetOwnerActor() && m_pWeapon->GetOwnerActor()->IsPlayer())
		m_pWeapon->GetGameObject()->InvokeRMI(CWeapon::SvRequestShoot(), CWeapon::RequestShootParams(m_shooterId, hit), eRMI_ToServer);

	return true;
}

//------------------------------------------------------------------------
void CShotgun::ResetParams(const struct IItemParamsNode *params)
{
	CSingle::ResetParams(params);

	const IItemParamsNode *shotgun = params?params->GetChild("shotgun"):0;
	m_shotgunparams.Reset(shotgun);
}

//------------------------------------------------------------------------
void CShotgun::PatchParams(const struct IItemParamsNode *patch)
{
	CSingle::PatchParams(patch);

	const IItemParamsNode *shotgun = patch->GetChild("shotgun");
	m_shotgunparams.Reset(shotgun, false);
}
//------------------------------------------------------------------------
Vec3 CShotgun::ApplySpread(const Vec3 &dir)
{
	float spread = m_shotgunparams.spread;
	Vec3 up = ZERO;
	Vec3 right = ZERO;
	Vec3 finalDir = dir;
	Matrix33 mat = Matrix33::CreateRotationXYZ(Ang3::GetAnglesXYZ(Quat::CreateRotationVDir(dir)));
	right = mat.GetColumn(0).normalize();
	up = mat.GetColumn(2).normalize();
	finalDir = Random(-1.0f, 1.0f) * spread * right + Random(-1.0f, 1.0f) * spread * up + dir;
	return finalDir;

}