#include "Single.h"
#pragma once

class CShotgun :
	public CSingle
{
protected:
	typedef struct SShotgunParams
	{
		SShotgunParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(pellets,			10);
			ResetValue(pelletdamage,				20);
			ResetValue(spread,			.1f);
		}

		short pellets;
		short	pelletdamage;
		float spread;

	} SShotgunParams;
public:
	CShotgun(void);
	~CShotgun(void);
	virtual void Reload(bool zoomed);
	virtual void StartReload(bool zoomed);
	virtual void ReloadShell(bool zoomed, bool pump);
	virtual void EndReload(bool zoomed, bool pump);

	virtual bool Shoot(bool resetAnimation, bool autoreload/* =true */);

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual Vec3 ApplySpread(const Vec3 &dir);
protected:
	SShotgunParams m_shotgunparams;
};
