#include "StdAfx.h"
#include "TagBullet.h"
#include "Game.h"
#include <IEntitySystem.h>
#include <IGameRulesSystem.h>

CTagBullet::CTagBullet(void)
{
}

CTagBullet::~CTagBullet(void)
{
}

void CTagBullet::HandleEvent(const SGameObjectEvent &event)
{
	if (m_destroying)
		return;

	CProjectile::HandleEvent(event);

	if (!strcmpi(event.event, "oncollision"))
	{
		EventPhysCollision *pCollision = reinterpret_cast<EventPhysCollision *>(event.ptr);
		if (!pCollision)
			return;

		IEntity *pTarget = pCollision->iForeignData[1]==PHYS_FOREIGN_ID_ENTITY ? (IEntity*)pCollision->pForeignData[1]:0;
		if (pTarget)
		{
			SGameObjectEvent evt("HUD_TagBullet",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, (void *)(UINT_PTR)pTarget->GetId());
			GetISystem()->GetIGame()->GetIGameFramework()->GetIGameObjectSystem()->BroadcastEvent(evt);
		}

		Destroy();
	}
}
