/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Throw Fire Mode Implementation

-------------------------------------------------------------------------
History:
- 261:10:2005   15:45 : Created by Mrcio Martins

*************************************************************************/
#ifndef __THROW_H__
#define __THROW_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "Single.h"


class CThrow : public CSingle
{
protected:
	typedef struct SThrowActions
	{
		SThrowActions() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValueEx("throw", throwit,		"throw");
			ResetValue(hold,		"hold");
			ResetValue(pull,		"pull");
		}

		string throwit;
		string hold;
		string pull;

	} SThrowActions;

	typedef struct SThrowParams
	{
		SThrowParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);
			ResetValue(delay, 				0.15f);
			ResetValue(hide_ammo,			true);
		}

		float	delay;
		bool	hide_ammo;

	} STrhowParams;
public:
	CThrow();
	virtual ~CThrow();

	virtual void Update(float frameTime, uint frameId);

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual void Activate(bool activate);

	virtual bool CanReload() const;
	virtual bool IsReadyToFire() const;
	virtual void StartFire(EntityId shooterId);
	virtual void StopFire(EntityId shooterId);

protected:

	virtual void CheckAmmo();
	virtual void DoThrow();

	bool	m_thrown;
	bool	m_pulling;
	bool	m_throwing;
	bool	m_auto_throw;
	float	m_throw_time;

	SThrowActions m_throwactions;
	SThrowParams	m_throwparams;
};

#endif 