/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Tracer Manager

-------------------------------------------------------------------------
History:
- 17:1:2006   11:12 : Created by Mrcio Martins

*************************************************************************/
#ifndef __TRACERMANAGER_H__
#define __TRACERMANAGER_H__

#if _MSC_VER > 1000
# pragma once
#endif


class CTracerPath
{
	typedef std::vector<Vec3> TPathPoints;
public:
	CTracerPath();
	virtual ~CTracerPath();

	void Reset();
	void AddPoint(const Vec3 &pt);
	Vec3 GetPoint() const;

	void First();
	void Next();
	bool IsEnd() const;

private:
	TPathPoints m_points;
	int					m_current;
};


class CTracer
{
	friend class CTracerManager;
public:
	CTracer(const Vec3 &pos);
	virtual ~CTracer();

	void SetGeometry(const char *name, float scale);
	void SetEffect(const char *name, float scale);
	void SetLifeTime(float lifeTime);
	bool Update(float frameTime, const Vec3 &campos);
	void UpdateVisual(const Vec3 &pos, const Vec3 &dir, float scale, float length);
	float GetAge() const;

private:
	CTracerPath	m_path;
	float				m_scale;
	float				m_speed;
	float				m_length;
	Vec3				m_pos;
	Vec3				m_startingpos;
	float				m_age;
	float				m_lifeTime;

	IRenderNode							*m_pRenderNode;
	_smart_ptr<IParticleEmitter>m_pEmitter;
	_smart_ptr<IStatObj>				m_pStatObj;
};


class CTracerManager
{
	typedef std::vector<CTracer *>				TTracerVector;
public:
	CTracerManager();
	virtual ~CTracerManager();

	typedef struct STracerParams
	{
		const char *geometry;
		const char *effect;
		Vec3				position;
		float				speed;
		float				scale;
		float				lifetime;
		CTracerPath	*path;
	};

	void EmitTracer(const STracerParams &params);
	void Update(float frameTime);
private:
	TTracerVector m_updating;
	TTracerVector	m_actives;
};


#endif //__TRACERMANAGER_H__