/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Implements the Trooper alien.
  
 -------------------------------------------------------------------------
  History:
  - 21:7:2005: Created by Mikko Mononen

*************************************************************************/
#ifndef __TROOPER_H__
#define __TROOPER_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "Alien.h"

struct STrooperBeam
{
	bool active;
	int effectSlot;
	EntityId beamTargetId;

	STrooperBeam()
	{
		memset(this,0,sizeof(STrooperBeam));
	}

	void CreateBeam(IEntity *owner,const char *effect,EntityId targetId);
	void RemoveBeam(IEntity *owner);
	void Update(IEntity *owner,float frameTime);
};

class CTrooper :
	public CAlien
{
public:

	virtual void Kill();
	virtual void Revive(bool fromInit = false);

	virtual void SetActorMovement(SOBJECTSTATE &control);

	virtual void CreateCodeEvent(SmartScriptTable &rTable);

	virtual void ProcessRotation(float frameTime);
	virtual void ProcessMovement(float frameTime);

	virtual void ProcessAnimation(ICharacterInstance *pCharacter,float frameTime);

	virtual void SetActorStance(SOBJECTSTATE &control, int& actions);

	virtual void UpdateStats(float frameTime);

	virtual bool IsFlying(){return false;}

protected:

	Quat m_modelQuat;//the model rotation
	
	STrooperBeam m_beamEffect;
};


#endif //__TROOPER_H__
