/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a damage behavior which create an explosion

-------------------------------------------------------------------------
History:
- 03:28:2006: Created by Mathieu Pinard

*************************************************************************/
#include "StdAfx.h"
#include "IVehicleSystem.h"
#include "VehicleDamageBehaviorBurn.h"
#include "Game.h"
#include "GameRules.h"

//------------------------------------------------------------------------
bool CVehicleDamageBehaviorBurn::Init(IVehicle* pVehicle, const SmartScriptTable &table)
{
	m_pVehicle = pVehicle;
	m_isActive = false;

	SmartScriptTable burnParams;
	if (table->GetValue("Burn", burnParams))
	{
		burnParams->GetValue("damage", m_damage);
		burnParams->GetValue("interval", m_interval);
		burnParams->GetValue("radius", m_radius);

		char* pHelperName = NULL;
		burnParams->GetValue("helper", pHelperName);
		m_helperName = pHelperName;

		return true;
	}

	return false;
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorBurn::Reset()
{
	if (m_isActive)
	{
		m_pVehicle->SetObjectUpdate(this, IVehicle::eVOU_AlwaysNoUpdate);
		m_isActive = false;
	}
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorBurn::OnDamageEvent(EVehicleDamageBehaviorEvent event, const SVehicleDamageBehaviorEventParams& behaviorParams)
{
	if (!m_isActive)
	{
		m_timeCounter = m_interval;
		m_pVehicle->SetObjectUpdate(this, IVehicle::eVOU_AlwaysUpdate);

		m_isActive = true;
	}
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorBurn::Update(const float deltaTime)
{
	m_timeCounter -= deltaTime;

	if (m_timeCounter <= 0.0f)
	{
		if (CGameRules* pGameRules = g_pGame->GetGameRules())
		{
			IEntitySystem* pEntitySystem = GetISystem()->GetIEntitySystem();

			IPhysicalEntity **pList;
			Vec3 worldPos = m_pVehicle->GetHelperWorldTM(m_helperName, false).GetTranslation();

			int count = pEntitySystem->GetPhysicalEntitiesInBox(worldPos, m_radius, pList, ent_all);

			for (int i = 0; i < count; i++)
			{
				IEntity *pEntity = pEntitySystem->GetEntityFromPhysics(pList[i]);
				if (pEntity)
				{
					CGameRules::HitInfo hitInfo;
					hitInfo.damage = m_damage;
					hitInfo.pos = m_pVehicle->GetHelperWorldTM(m_helperName, false).GetTranslation();
					hitInfo.radius = m_radius;
					hitInfo.shooterId = 0;
					hitInfo.targetId = pEntity->GetId();
					hitInfo.type = pGameRules->GetHitTypeId("explosion");
					pGameRules->ServerHit(hitInfo);
				}
			}
		}

		m_timeCounter = m_interval;
	}
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorBurn::Serialize(TSerialize ser, unsigned aspects)
{

}

DEFINE_VEHICLEOBJECT(CVehicleDamageBehaviorBurn);
