/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a damage behavior which create an explosion

-------------------------------------------------------------------------
History:
- 03:28:2006: Created by Mathieu Pinard

*************************************************************************/
#include "StdAfx.h"
#include "IVehicleSystem.h"
#include "VehicleDamageBehaviorExplosion.h"
#include "Game.h"
#include "GameRules.h"

//------------------------------------------------------------------------
bool CVehicleDamageBehaviorExplosion::Init(IVehicle* pVehicle, const SmartScriptTable &table)
{
	m_pVehicle = pVehicle;

	SmartScriptTable explosionParams;
	if (table->GetValue("Explosion", explosionParams))
	{
		explosionParams->GetValue("damage", m_damage);
		explosionParams->GetValue("radius", m_radius);
		explosionParams->GetValue("pressure", m_pressure);

		char* pHelperName = NULL;
		explosionParams->GetValue("helper", pHelperName);
		m_helperName = pHelperName;

		return true;
	}

	return false;
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorExplosion::OnDamageEvent(EVehicleDamageBehaviorEvent event, const SVehicleDamageBehaviorEventParams& behaviorParams)
{
	if (behaviorParams.componentDamageRatio > 1.0f)
	{
		if (CGameRules* pGameRules = g_pGame->GetGameRules())
		{
			CGameRules::ExplosionInfo explosionInfo;
			explosionInfo.damage = m_damage;
			explosionInfo.damage += (behaviorParams.randomness) * Random() * m_damage;
			explosionInfo.pos = m_pVehicle->GetHelperWorldTM(m_helperName, false).GetTranslation();
			explosionInfo.radius = m_radius;
			explosionInfo.shooterId = m_pVehicle->GetEntityId();
			explosionInfo.pressure = m_pressure;
			pGameRules->ServerExplosion(explosionInfo);
		}
	}
}

DEFINE_VEHICLEOBJECT(CVehicleDamageBehaviorExplosion);
