/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a standard helicopter movements

-------------------------------------------------------------------------
History:
- 09:05:2005: Created by Mathieu Pinard

*************************************************************************/
#ifndef __VEHICLEMOVEMENTHELICOPTER_H__
#define __VEHICLEMOVEMENTHELICOPTER_H__

#include "VehicleMovementBase.h"

#include "Network/NetActionSync.h"
#include "AIMovementCommon.h"


class CVehicleMovementHelicopter;



class CNetworkMovementHelicopter
{
public:
	CNetworkMovementHelicopter();
	CNetworkMovementHelicopter(CVehicleMovementHelicopter *pMovement);

	
	typedef CVehicleMovementHelicopter * UpdateObjectSink;

	
	bool operator == (const CNetworkMovementHelicopter &rhs)
	{
		const float epsilon = 0.0001f;

		return
			(abs(m_actionPower-rhs.m_actionPower)<epsilon) &&
			(abs(m_actionPitch-rhs.m_actionPitch)<epsilon) &&
			(abs(m_actionYaw-rhs.m_actionYaw)<epsilon) &&
			(abs(m_actionRoll-rhs.m_actionRoll)<epsilon);
	};

	bool operator != (const CNetworkMovementHelicopter &rhs)
	{
		return !this->operator==(rhs);
	};

	void UpdateObject( CVehicleMovementHelicopter *pMovement );
	void Serialize(TSerialize ser, unsigned aspects);

	static const uint8 CONTROLLED_ASPECT = eEA_GameClientDynamic;

private:
	float m_actionPower;
	float m_actionPitch;
	float m_actionYaw;
	float m_actionRoll;
};


class CVehicleMovementHelicopter
	: public CVehicleMovementBase
{
public:

	CVehicleMovementHelicopter();
	virtual ~CVehicleMovementHelicopter() {}

	// IVehicleMovement
	virtual bool Init(IVehicle* pVehicle, const SmartScriptTable &table);
	virtual void PostInit();
	virtual void Reset();
	virtual void Release();
	virtual void Physicalize();

	virtual bool StartEngine(EntityId driverId);
	virtual void StopEngine();

	virtual void OnEvent(EVehicleMovementEvent event, float value);
	virtual void OnAction(const char *actionName, int activationMode, float value);

	virtual void ProcessMovement(const float deltaTime);
	virtual void ProcessActions(const float deltaTime);
	virtual void ProcessAI(const float deltaTime);
	
	virtual void Update(const float deltaTime);

	virtual bool RequestMovement(CMovementRequest& movementRequest);

	virtual void Serialize(TSerialize ser, unsigned aspects);
	virtual void SetChannelId(uint16 id) {};
	virtual void SetAuthority(bool auth) { m_netActionSync.CancelReceived(); };
	// ~IVehicleMovement

	// CVehicleMovementBase
	virtual void OnEngineCompletelyStopped();
	// ~CVehicleMovementBase

protected:

	void ResetActions();

	void UpdateEngine(float deltaTime);
	bool IsStable();
	bool IsImmobile();

	// animation stuff
	IVehicleAnimation* m_pRotorAnim;
	IVehicleAnimation* m_pLandingGearsAnim;

	// movement settings (shouldn't be changed outside Init())

	float m_altitudeMax;
	float m_rotationDamping;
	float m_dampInertia;
	float m_dampInertiaIdle;

	float m_engineForce;
	float m_engineForceDeceleration;
	float m_engineAngle;
	float m_engineAngleForward;
	float m_engineAltAngle;
	float m_engineActualAngle;
	float m_engineRotationSpeed;

	float m_enginePower;
	float m_enginePowerMax;

	float m_movingSpeed;
	float m_rollSpeed;
	float m_pitchSpeed;
	float m_yawSpeed;
	
	float m_rollWYawAngle;
	float m_rollRelax;
	float m_pitchRelax;

	// movement states (shouldn't be changed outside ProcessMovement())

	Vec3 m_engineDir;
	float m_engineGoalThrottle;	
	
	bool m_isDestroyed;
	float m_steeringDamage;

	// movement actions (to be modified by AI and player actions)
	float m_liftAction;
	float m_forwardAction;
	float m_afterburnerAction;

	float m_pitchAction;
	float m_rollAction;
	float m_yawAction;

	float m_pitchActionMul;

	// ai
	CMovementRequest m_aiRequest;

	// Network related
	CNetActionSync<CNetworkMovementHelicopter> m_netActionSync;

	SPID	m_powerPID;
	float	m_LastControl;

	friend class CNetworkMovementHelicopter;
};

#endif
