
/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements Hovercraft movement

-------------------------------------------------------------------------
History:
- 27:04:2005: Created by Michael Rauh

*************************************************************************/
#ifndef __VEHICLEMOVEMENTHOVERCRAFT_H__
#define __VEHICLEMOVEMENTHOVERCRAFT_H__

#include "VehicleMovementBase.h"

struct hoverDebugValues {
	float vel;
	float dist;
	float spring;
	float damp;
};

class CVehicleMovementHovercraft  
  : public CVehicleMovementBase
{
public:

  // thruster for hovering
  struct Thruster {      
    Thruster( const Vec3& vpos, const Vec3& vdir ){
      pos = vpos;
      dir = vdir;
      maxForce = 0;
      pedal = 0;
      force = 0;
      tiltAngle = 0;
    }
    Vec3 pos;   // in vehicle frame
    Vec3 dir;   
    float maxForce;
    float pedal; // [-1..1]
    float force;
    float tiltAngle;
  };

  CVehicleMovementHovercraft();
  ~CVehicleMovementHovercraft();

  virtual bool Init(IVehicle* pVehicle, const SmartScriptTable &table);
  virtual void Release();
	virtual void Physicalize();

  
	virtual bool SetParams(const SmartScriptTable &table);
	virtual bool SetSounds(const SmartScriptTable &table) { return true; }

	virtual bool StartEngine(EntityId driverId);
	
	virtual void ProcessMovement(const float deltaTime);

	virtual void Serialize(TSerialize ser, unsigned aspects) {};

  virtual void Update(const float deltaTime);

private:

  // thrusters
  float m_liftForce;
  std::vector<Thruster*> m_vecThrusters;  
  int m_numThrusters;
  float m_hoverHeight;
  float m_thrustHeightCoeff;
  float m_stiffness;
  float m_damping;
  float m_thrusterTilt;
  float m_dampLimitCoeff;
  
  // driving
  float m_velMax;
  float m_accel;
  float m_accelCoeff;
  Vec3  m_pushOffset;
  float m_pushTilt;

  // steering
  float m_turnRateMax;
  float m_turnAccel;
  float m_turnAccelCoeff;  
  float m_cornerForceCoeff;
  Vec3  m_cornerOffset;
  float m_cornerTilt;
  float m_turnDamping;

  // stabilization
  Vec3 m_stabRate;

  Vec3 m_Inertia;
  float m_gravity;
  Vec3 m_massOffset;

  bool m_bEngineAlwaysOn;
	
	hoverDebugValues m_lastVals[10];
};
#endif
