/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a parachute vehicle movement

-------------------------------------------------------------------------
History:
- 14:07:2005: Created by Julien Darre

*************************************************************************/
#ifndef __VEHICLEMOVEMENTPARACHUTE_H__
#define __VEHICLEMOVEMENTPARACHUTE_H__

//-----------------------------------------------------------------------------------------------------

#include "VehicleSystem.h"
#include "VehicleMovementAerodynamic.h"

//-----------------------------------------------------------------------------------------------------

class CVehicleMovementParachute : public CVehicleMovementAerodynamic
{
public:

						CVehicleMovementParachute();
	virtual ~	CVehicleMovementParachute();

	// IVehicleMovement
	virtual bool Init(IVehicle *, const SmartScriptTable &);
  virtual void Release();

  virtual bool SetParams(const SmartScriptTable &);
	virtual bool SetSounds(const SmartScriptTable &) { return true; }

	virtual bool StartEngine(EntityId) { return true; }
	virtual void StopEngine() {}

	virtual void ProcessMovement(const float);
	virtual void RequestActions(const SVehicleMovementAction& _rVehicleMovementAction) { m_movementAction = _rVehicleMovementAction; }
	virtual void Update(const float deltaTime) {}

	virtual void Serialize(TSerialize, unsigned aspects) {};
	// ~IVehicleMovement

private:

	TPointsMap m_LiftPointsMap;
	TPointsMap m_DragPointsMap;

	SWing m_aCels[7];

	void AddCel(int,SWing *);
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------